/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefCtree;
import com.xrefactory.jedit.XrefRefListArea;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.XrefTask;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class BrowserTopPanel
extends JSplitPane {
    public static final String[] refViews = new String[]{"Filter 0", "Filter 1", "Filter 2", "Filter 3"};
    public static final String[] treeViews = new String[]{"Equal Name", "Equal Profile", "Relevant"};
    DispatchData data;
    public TreePanel treePanel;
    public ReferencesPanel referencesPanel;
    boolean needToUpdate = false;

    public void updateData() {
        s.Position position = s.getPosition(s.getParentView(this));
        this.treePanel.treeFilter.setSelectedIndex(Opt.browserTreeFilter);
        this.needToUpdate = false;
        s.moveToPosition(position);
    }

    public void needToUpdate() {
        if (s.browserIsDisplayed(this)) {
            this.updateData();
        } else {
            this.needToUpdate = true;
        }
    }

    public void paint(Graphics graphics) {
        if (this.needToUpdate) {
            this.needToUpdate();
        }
        super.paint(graphics);
    }

    BrowserTopPanel(DispatchData dispatchData, int n) {
        super(1, false);
        this.data = dispatchData;
        this.treePanel = new TreePanel(dispatchData);
        this.setLeftComponent(this.treePanel);
        this.referencesPanel = new ReferencesPanel(dispatchData);
        this.setRightComponent(this.referencesPanel);
        int n2 = Opt.browserTreeDividerPosition();
        this.treePanel.setPreferredSize(new Dimension(n2, 200));
        int n3 = 500 - n2;
        if (n3 < 100) {
            n3 = 100;
        }
        this.referencesPanel.setPreferredSize(new Dimension(n3, 200));
    }

    public static class ReferencesPanel
    extends JPanel {
        DispatchData data;
        XrefRefListArea reflist;
        ComboBoxRefsFilter refFilter;

        public void updateSelection() {
            DispatchData dispatchData = new DispatchData(this.data, (Component)this);
            XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessSingleOpt("-olcxgetcurrentrefn", dispatchData);
            Dispatch.dispatch(xrefCharBuffer, dispatchData);
        }

        public void update() {
            DispatchData dispatchData = new DispatchData(this.data, (Component)this);
            XrefStringArray xrefStringArray = new XrefStringArray();
            xrefStringArray.add("-olcxfilter=" + Opt.browserRefListFilter);
            dispatchData.xTask.addFileProcessingOptions(xrefStringArray);
            XrefTask.addCommonOptions(xrefStringArray, dispatchData);
            XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcess(xrefStringArray, dispatchData);
            Dispatch.dispatch(xrefCharBuffer, dispatchData);
        }

        ReferencesPanel(DispatchData dispatchData) {
            this.data = dispatchData;
            this.reflist = new XrefRefListArea(dispatchData);
            this.refFilter = new ComboBoxRefsFilter();
            JButton[] jButtonArray = new JButton[]{new ButtonPrevious(), new ButtonNext()};
            JScrollPane jScrollPane = new JScrollPane(this.reflist);
            this.setLayout(new GridBagLayout());
            int n = -1;
            s.addGbcComponent(this, 0, ++n, jButtonArray.length, 1, 1, 1, 2, this.refFilter);
            s.addGbcComponent(this, 0, ++n, jButtonArray.length, 1, 100, 100, 1, jScrollPane);
            ++n;
            int n2 = 0;
            while (n2 < jButtonArray.length) {
                s.addGbcComponent(this, n2, n, 1, 1, 1, 1, 2, jButtonArray[n2]);
                ++n2;
            }
        }

        class ButtonNext
        extends JButton
        implements ActionListener {
            ButtonNext() {
                super("Next");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesPanel.this.reflist.next();
            }
        }

        class ButtonPrevious
        extends JButton
        implements ActionListener {
            ButtonPrevious() {
                super("Previous");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesPanel.this.reflist.previous();
            }
        }

        class ComboBoxRefsFilter
        extends JComboBox
        implements ActionListener {
            ComboBoxRefsFilter() {
                super(refViews);
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Opt.browserRefListFilter = ReferencesPanel.this.refFilter.getSelectedIndex();
                ReferencesPanel.this.update();
            }
        }
    }

    public class TreePanel
    extends JPanel {
        DispatchData data;
        public XrefCtree xtree;
        public JComboBox treeView;
        public ComboBoxTreeFilter treeFilter;

        TreePanel(DispatchData dispatchData) {
            this.data = dispatchData;
            JButton[] jButtonArray = new JButton[]{new ButtonAll(), new ButtonNone()};
            this.xtree = new XrefCtree(dispatchData);
            this.setLayout(new GridBagLayout());
            this.treeFilter = new ComboBoxTreeFilter();
            int n = 0;
            s.addGbcComponent(this, 0, n, jButtonArray.length, 1, 1, 1, 2, this.treeFilter);
            s.addGbcComponent(this, 0, ++n, jButtonArray.length, 1, 100, 100, 1, new JScrollPane(this.xtree));
            ++n;
            int n2 = 0;
            while (n2 < jButtonArray.length) {
                s.addGbcComponent(this, n2, n, 1, 1, 1, 1, 2, jButtonArray[n2]);
                ++n2;
            }
        }

        class ComboBoxTreeFilter
        extends JComboBox
        implements ActionListener {
            ComboBoxTreeFilter() {
                super(treeViews);
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Opt.browserTreeFilter = TreePanel.this.treeFilter.getSelectedIndex();
                DispatchData dispatchData = new DispatchData(TreePanel.this.data, (Component)this);
                XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessSingleOpt("-olcxmenufilter=" + Opt.browserTreeFilter, dispatchData);
                Dispatch.dispatch(xrefCharBuffer, dispatchData);
                ((TreePanel)TreePanel.this).BrowserTopPanel.this.referencesPanel.refFilter.setSelectedIndex(Opt.browserRefListFilter);
            }
        }

        class ButtonDefault
        extends JButton
        implements ActionListener {
            ButtonDefault() {
                super("Default");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        class ButtonNone
        extends JButton
        implements ActionListener {
            ButtonNone() {
                super("None");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                s.getParentTreePanel((Component)this).xtree.selectUnselectAll(false);
            }
        }

        class ButtonAll
        extends JButton
        implements ActionListener {
            ButtonAll() {
                super("All");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                s.getParentTreePanel((Component)this).xtree.selectUnselectAll(true);
            }
        }
    }
}

