/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.s;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;

public class CompletionDialog
extends JDialog
implements KeyListener {
    DispatchData data;
    JScrollPane scrollPane;
    JTextArea textArea;
    String text;
    LinkedList history;
    String insertFile;
    int insertOffset;
    static CompletionDialog lastcDialog;

    public static void insertFqtCompletion(Buffer buffer, int n, String string) {
        int n2;
        int n3 = -1;
        while ((n2 = string.indexOf(46, n3 + 1)) != -1) {
            n3 = n2;
        }
        if (n3 < 0) {
            CompletionDialog.insertCompletion(buffer, n, string);
            return;
        }
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3 + 1);
        new FqtCompletionDialog(string2, string3, buffer, n);
    }

    public static void addImportAndInsertCompletion(String string, Buffer buffer, int n, String string2) {
        try {
            DispatchData dispatchData = new DispatchData(s.xbTask, (Component)s.view);
            XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessOnFileNoSaves(new String[]{"-olcxtrivialprecheck", "-getlastimportline"}, dispatchData);
            Dispatch.dispatch(xrefCharBuffer, dispatchData);
            int n2 = Integer.parseInt(dispatchData.info);
            int n3 = buffer.getLineStartOffset(n2);
            String string3 = "import " + string + "\n";
            buffer.insert(n3, string3);
            CompletionDialog.insertCompletion(buffer, n + string3.length(), string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void insertCompletion(Buffer buffer, int n, String string) {
        int n2;
        int n3 = n2 = n;
        int n4 = buffer.getLength();
        while (n2 < n4 && Character.isJavaLetter(buffer.getText(n2, 1).charAt(0))) {
            ++n2;
        }
        int n5 = n2 - n3;
        String string2 = buffer.getText(n3, n2 - n3);
        String string3 = s.commonPrefix(string2, string);
        int n6 = string3.length();
        buffer.remove(n3 + n6, n5 - n6);
        buffer.insert(n3 + n6, string.substring(n6));
        s.getTextArea().setCaretPosition(n + string.length());
    }

    public static String getPrefixOnCompletion() {
        int n = s.getCaretPosition();
        int n2 = n - 1;
        while (n2 > 0 && Character.isJavaLetter(s.getBuffer().getText(n2, 1).charAt(0))) {
            --n2;
        }
        return s.getBuffer().getText(++n2, n - n2);
    }

    public static int charCount(String string, char c, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        while ((n3 = string.indexOf(c, n3)) != -1 && n3 < n2) {
            ++n4;
            ++n3;
        }
        return n4;
    }

    int getCompletionLineNumber(int n) {
        int n2 = CompletionDialog.charCount(this.text, '\n', 0, n + 1);
        return n2;
    }

    void displayProfileIfShouldBeDisplayed() {
        try {
            int n = this.textArea.getCaretPosition();
            int n2 = this.textArea.getLineOfOffset(n);
            int n3 = this.textArea.getLineStartOffset(n2);
            int n4 = this.textArea.getLineEndOffset(n2);
            String string = this.textArea.getText(n3, n4 - n3);
            int n5 = string.length() - 1;
            while (n5 >= 0) {
                if (string.charAt(n5) == '(' && n5 < string.length() - 1 && n5 > 0 && string.charAt(n5 - 1) != ':' && string.charAt(n5 + 1) != ')' || string.charAt(n5) == ':') break;
                --n5;
            }
            if (n5 >= 0 && string.charAt(n5) == '(') {
                while (n5 > 0 && string.charAt(n5) != ' ') {
                    --n5;
                }
                String string2 = string.substring(n5, string.length());
                SwingUtilities.invokeLater(new s.MessageDisplayer(string2, false));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        boolean bl2 = bl = n == 9;
        if (n != 38 && n != 40 && n != 224 && n != 225 && n != 33 && n != 34 && n != 37 && n != 39 && n != 36 && n != 35) {
            keyEvent.consume();
        }
        if (n == 10) {
            int n3 = this.textArea.getCaretPosition();
            int n4 = this.getCompletionLineNumber(n3);
            this.setVisible(false);
            this.displayProfileIfShouldBeDisplayed();
            DispatchData dispatchData = new DispatchData(this.data, (Component)this);
            XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessSingleOpt("-olcomplselect" + n4, dispatchData);
            Dispatch.dispatch(xrefCharBuffer, dispatchData);
        } else if (n == 32 && (keyEvent.getModifiers() & 2) != 0) {
            this.closeDialog();
            s.moveToPosition(s.getParentView(this), this.insertFile, this.insertOffset);
            CompletionDialog.completion(s.view);
        } else if (n == 32) {
            int n5 = this.textArea.getCaretPosition();
            int n6 = this.getCompletionLineNumber(n5);
            DispatchData dispatchData = new DispatchData(this.data, (Component)this);
            XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessSingleOpt("-olcxcgoto" + n6, dispatchData);
            Dispatch.dispatch(xrefCharBuffer, dispatchData);
        } else if (n == 8) {
            if (this.history.size() > 1) {
                int n7 = ((HistoryElem)this.history.getFirst()).selection.length();
                this.history.removeFirst();
                int n8 = ((HistoryElem)this.history.getFirst()).selection.length();
                this.showSelection();
                if (n8 < n7) {
                    s.moveToPosition(s.getParentView(this), this.insertFile, this.insertOffset);
                    --this.insertOffset;
                    s.getBuffer().remove(this.insertOffset, 1);
                }
            }
        } else if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || bl) {
            String string;
            int n9 = ((HistoryElem)this.history.getFirst()).caret;
            String string2 = string = ((HistoryElem)this.history.getFirst()).selection;
            if (bl) {
                ++n9;
            } else {
                string2 = string + c;
            }
            int n10 = this.text.toLowerCase().indexOf("\n" + string2.toLowerCase(), n9);
            if (n10 != -1) {
                this.history.addFirst(new HistoryElem(n10, string2));
                this.showSelection();
                if (!bl) {
                    int n11 = n10 + string2.length();
                    String string3 = this.text.substring(n11, n11 + 1);
                    s.moveToPosition(s.getParentView(this), this.insertFile, this.insertOffset);
                    s.getBuffer().insert(this.insertOffset, string3);
                    ++this.insertOffset;
                }
            }
        } else if ("`~!@#$%^&*()_+|-=\\{}[]:\";'<>?,./".indexOf(c) != -1) {
            this.closeDialog();
            s.moveToPosition(s.getParentView(this), this.insertFile, this.insertOffset);
            s.getBuffer().insert(this.insertOffset, "" + c);
        } else if (n == 27) {
            this.closeDialog();
            if (n2 == 1 || n2 == 8) {
                s.moveToPosition(s.getParentView(this), this.insertFile, this.insertOffset);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    void showSelection() {
        int n = ((HistoryElem)this.history.getFirst()).caret;
        String string = ((HistoryElem)this.history.getFirst()).selection;
        this.textArea.setCaretPosition(n);
        this.textArea.moveCaretPosition(n + string.length());
    }

    void closeDialog() {
        this.setVisible(false);
    }

    public static void completion(View view) {
        if (s.activeProject != null) {
            XrefStringArray xrefStringArray = new XrefStringArray();
            xrefStringArray.add("-olcxcomplet");
            xrefStringArray.add("-maxcompls=" + Opt.maxCompletions());
            if (Opt.completeFullyQualifiedNames()) {
                xrefStringArray.add("-olfqtnametocompletions");
            }
            if (Opt.completionLinkageCheck()) {
                xrefStringArray.add("-olchecklinkage");
            }
            if (Opt.completionAccessCheck()) {
                xrefStringArray.add("-olcheckaccess");
            }
            DispatchData dispatchData = new DispatchData(s.xbTask, (Component)view);
            XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessOnFileNoSaves(xrefStringArray.toStringArray(true), dispatchData);
            Dispatch.dispatch(xrefCharBuffer, dispatchData);
        }
    }

    CompletionDialog(String string, DispatchData dispatchData) {
        super((Frame)s.view, "");
        if (s.javaVersion.compareTo("1.4.0") >= 0) {
            this.setUndecorated(true);
        }
        if (lastcDialog != null && lastcDialog.isVisible()) {
            lastcDialog.setVisible(false);
        }
        lastcDialog = this;
        this.data = dispatchData;
        this.enableEvents(8L);
        String string2 = CompletionDialog.getPrefixOnCompletion();
        this.text = "\n" + string;
        this.textArea = new JTextArea(string);
        this.textArea.setBackground(new Color(255, 240, 200));
        this.textArea.setEditable(true);
        this.insertOffset = s.getCaretPosition();
        this.insertFile = s.getFileName();
        this.scrollPane = new JScrollPane(this.textArea);
        this.setContentPane(this.scrollPane);
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.getHeight() > (double)Opt.completionDialogMaxHeight()) {
            dimension.setSize(dimension.getWidth() + 20.0, (double)Opt.completionDialogMaxHeight());
        }
        if (dimension.getWidth() > (double)Opt.completionDialogMaxWidth()) {
            dimension.setSize((double)Opt.completionDialogMaxWidth(), dimension.getHeight() + 20.0);
        }
        this.setSize(dimension);
        this.setLocation(s.recommendedLocation((Component)s.getTextArea()));
        s.moveOnScreen(this);
        this.textArea.addKeyListener(this);
        this.history = new LinkedList();
        this.history.addFirst(new HistoryElem(0, string2));
        this.showSelection();
        this.setVisible(true);
    }

    public static class FqtCompletionDialog
    extends JDialog {
        FqtCompletionDialog(String string, String string2, Buffer buffer, int n) {
            super((Frame)s.view, "", true);
            this.enableEvents(8L);
            this.setContentPane(new FqtCompletionPanel(string, string2, buffer, n));
            this.setLocation(s.recommendedLocation((Component)s.getTextArea()));
            s.moveOnScreen(this);
            if (s.javaVersion.compareTo("1.4.0") >= 0) {
                this.setUndecorated(true);
            }
            this.pack();
            this.setVisible(true);
        }

        static class FqtCompletionPanel
        extends JPanel
        implements KeyListener {
            JList list;
            String pack;
            String cl;
            Buffer buffer;
            int offset;

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    s.getParentDialog(this).setVisible(false);
                } else if (keyEvent.getKeyCode() == 10) {
                    s.getParentDialog(this).setVisible(false);
                    switch (this.list.getSelectedIndex()) {
                        case 0: {
                            CompletionDialog.addImportAndInsertCompletion(this.pack + ".*;", this.buffer, this.offset, this.cl);
                            break;
                        }
                        case 1: {
                            CompletionDialog.addImportAndInsertCompletion(this.pack + "." + this.cl + ";", this.buffer, this.offset, this.cl);
                            break;
                        }
                        case 2: {
                            CompletionDialog.insertCompletion(this.buffer, this.offset, this.pack + "." + this.cl);
                        }
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            FqtCompletionPanel(String string, String string2, Buffer buffer, int n) {
                this.pack = string;
                this.cl = string2;
                this.buffer = buffer;
                this.offset = n;
                this.setLayout(new GridBagLayout());
                this.list = new JList<String>(new String[]{"import " + string + ".* and complete " + string2, "import " + string + "." + string2 + " and complete " + string2, "complete " + string + "." + string2});
                this.list.addKeyListener(this);
                this.list.setBackground(s.LIGHT_GRAY);
                this.list.setSelectedIndex(0);
                JTextArea jTextArea = new JTextArea("Fully qualified type name completion will:");
                jTextArea.setEditable(false);
                jTextArea.setBackground(s.LIGHT_GRAY);
                if (s.javaVersion.compareTo("1.4.0") >= 0) {
                    jTextArea.setFocusable(false);
                }
                int n2 = 0;
                s.addGbcComponent(this, 0, n2, 1, 1, 1, 1, 1, jTextArea);
                s.addGbcComponent(this, 0, ++n2, 1, 1, 1, 1, 1, this.list);
            }
        }
    }

    static class HistoryElem {
        int caret;
        String selection;

        HistoryElem(int n, String string) {
            this.caret = n;
            this.selection = string;
        }
    }
}

