/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.ArrayEnumerator;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeNode;

class DirectoryNode
implements TreeNode,
Comparable {
    File ff;
    DirectoryNode parent;
    DirectoryNode[] subs = null;
    String name;
    boolean isDirectory;

    private boolean fileFilter(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName();
        int n = string.length();
        if (string.lastIndexOf(".java") == n - 5) {
            return true;
        }
        if (string.lastIndexOf(".JAVA") == n - 5) {
            return true;
        }
        if (string.lastIndexOf(".jav") == n - 4) {
            return true;
        }
        if (string.lastIndexOf(".JAV") == n - 4) {
            return true;
        }
        if (string.lastIndexOf(".jar") == n - 4) {
            return true;
        }
        if (string.lastIndexOf(".JAR") == n - 4) {
            return true;
        }
        if (string.lastIndexOf(".zip") == n - 4) {
            return true;
        }
        return string.lastIndexOf(".ZIP") == n - 4;
    }

    public int compareTo(Object object) {
        return this.ff.getName().compareTo(((DirectoryNode)object).ff.getName());
    }

    private void setSubs() {
        File[] fileArray = FileSystemView.getFileSystemView().getFiles(this.ff, true);
        int n = 0;
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (this.fileFilter(fileArray[n2])) {
                ++n;
            }
            ++n2;
        }
        this.subs = new DirectoryNode[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < fileArray.length) {
            if (this.fileFilter(fileArray[n4])) {
                this.subs[n3] = new DirectoryNode(this, fileArray[n4]);
                ++n3;
            }
            ++n4;
        }
        Arrays.sort(this.subs);
    }

    public Enumeration children() {
        if (this.subs == null) {
            this.setSubs();
        }
        return new ArrayEnumerator(this.subs);
    }

    public TreeNode getChildAt(int n) {
        if (this.subs == null) {
            this.setSubs();
        }
        return this.subs[n];
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean getAllowsChildren() {
        if (this.subs == null) {
            this.setSubs();
        }
        return this.subs.length != 0;
    }

    public boolean isLeaf() {
        if (this.subs == null) {
            this.setSubs();
        }
        return this.subs.length == 0 && !this.isDirectory;
    }

    public int getChildCount() {
        if (this.subs == null) {
            this.setSubs();
        }
        return this.subs.length;
    }

    public int getIndex(TreeNode treeNode) {
        if (this.subs == null) {
            this.setSubs();
        }
        int n = 0;
        while (n < this.subs.length) {
            if (treeNode == this.subs[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String toString() {
        return this.name;
    }

    DirectoryNode(DirectoryNode directoryNode, File file) {
        this.parent = directoryNode;
        this.ff = file;
        this.isDirectory = file.isDirectory();
        String string = file.toString();
        String string2 = file.getAbsolutePath();
        this.name = string.equals(string2) ? file.getName() : string;
        if (this.name.equals("")) {
            this.name = string;
        }
    }
}

