/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.BrowserTopPanel;
import com.xrefactory.jedit.CompletionDialog;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.ExtractMethodDialog;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.OptionsForProjectsDialog;
import com.xrefactory.jedit.Protocol;
import com.xrefactory.jedit.RefactoringDialog;
import com.xrefactory.jedit.Refactorings;
import com.xrefactory.jedit.ResolutionDialog;
import com.xrefactory.jedit.XrefAbortException;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefClassTreeDialog;
import com.xrefactory.jedit.XrefErrorException;
import com.xrefactory.jedit.XrefException;
import com.xrefactory.jedit.XrefTreeNode;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HelpViewer;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;

public class Dispatch {
    static String currentTag;
    static int attrLen;
    static int attrLine;
    static int attrCol;
    static int attrOffset;
    static int attrVal;
    static int attrSelected;
    static int attrMType;
    static int attrBase;
    static int attrDRefn;
    static int attrRefn;
    static int attrIndent;
    static int attrInterface;
    static int attrDefinition;
    static int attrTreeUp;
    static int attrContinue;
    static String attrTreeDeps;
    static String attrType;
    static String block;

    static void clearAttributes() {
        attrLen = 0;
        attrLine = 0;
        attrCol = 0;
        attrOffset = 0;
        attrVal = 0;
        attrSelected = 0;
        attrMType = 0;
        attrBase = 0;
        attrDRefn = 0;
        attrRefn = 0;
        attrIndent = 0;
        attrInterface = 0;
        attrDefinition = 0;
        attrTreeUp = 0;
        attrTreeDeps = null;
        attrType = null;
    }

    static void browseUrl(String string, DispatchData dispatchData) {
        try {
            int n = 0;
            if (Opt.askBeforeBrowsingJavadoc()) {
                n = JOptionPane.showConfirmDialog(s.getProbableParent(dispatchData.callerComponent), "Browse URL: " + string + "?", "Confirmation", 0, 3);
            }
            if (n == 0) {
                if (s.xHelpViewer == null) {
                    s.xHelpViewer = new HelpViewer();
                } else if (!s.xHelpViewer.isVisible()) {
                    s.xHelpViewer.dispose();
                    s.xHelpViewer = new HelpViewer();
                }
                s.xHelpViewer.gotoURL(string, true);
                s.xHelpViewer.requestFocus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void editorPreCheck(String string) throws XrefException {
        int n;
        Buffer buffer = s.getBuffer();
        String string2 = buffer.getText(n = s.getCaretPosition(), string.length());
        if (!string2.equals(string)) {
            throw new XrefException("expecting string " + string + " at this place, probably not updated references?");
        }
    }

    public static void editorReplace(String string, String string2) throws XrefException {
        int n;
        Buffer buffer = s.getBuffer();
        String string3 = buffer.getText(n = s.getCaretPosition(), string.length());
        if (!string3.equals(string)) {
            throw new XrefException("should replace " + string + " with " + string2 + ", but find " + string3 + " on this place");
        }
        buffer.remove(n, string.length());
        buffer.insert(n, string2);
    }

    static void protocolCheckEq(String string, String string2) throws Exception {
        if (!string.equals(string2)) {
            throw new XrefException("Internal protocol error, got '" + string + "' while expecting '" + string2 + "'");
        }
    }

    public static int skipMyXmlIdentifier(XrefCharBuffer xrefCharBuffer, int n, int n2) {
        char c = xrefCharBuffer.buf[n];
        while (n < n2 && (Character.isLetterOrDigit(c) || c == '-')) {
            c = xrefCharBuffer.buf[++n];
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public static int skipAttribute(XrefCharBuffer var0, int var1_1, int var2_2) {
        block4: {
            var3_3 = var0.buf[var1_1];
            if (var3_3 != '\"') ** GOTO lbl11
            var3_3 = ' ';
            while (var1_1 < var2_2 && var3_3 != '\"' && var3_3 != '\n') {
                var3_3 = var0.buf[++var1_1];
            }
            if (var1_1 >= var2_2 || var3_3 != 34) break block4;
            ++var1_1;
            break block4;
lbl-1000:
            // 1 sources

            {
                var3_3 = var0.buf[++var1_1];
lbl11:
                // 2 sources

                ** while (var1_1 < var2_2 && var3_3 != '>' && !Character.isSpace((char)var3_3))
            }
        }
        return var1_1;
    }

    public static String unquote(String string) {
        int n = string.length();
        if (n >= 2 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            return string.substring(1, n - 1);
        }
        return string;
    }

    public static String getContext(XrefCharBuffer xrefCharBuffer, int n, int n2) {
        int n3 = n + 20;
        String string = "";
        if (n3 >= n2) {
            n3 = n2;
        } else {
            string = " ...";
        }
        return xrefCharBuffer.substring(n, n3) + string;
    }

    public static int parseXmlTag(XrefCharBuffer xrefCharBuffer, int n, int n2) throws Exception {
        if ((n = s.skipBlank(xrefCharBuffer, n, n2)) >= n2) {
            throw new XrefException("parsing beyond end of communication string");
        }
        if (xrefCharBuffer.buf[n] != '<') {
            throw new XrefException("tag does not start with '<' (" + Dispatch.getContext(xrefCharBuffer, n, n2) + ")");
        }
        int n3 = ++n;
        if (xrefCharBuffer.buf[n] == '/') {
            ++n;
        }
        n = Dispatch.skipMyXmlIdentifier(xrefCharBuffer, n, n2);
        currentTag = xrefCharBuffer.substring(n3, n);
        n = s.skipBlank(xrefCharBuffer, n, n2);
        while (xrefCharBuffer.buf[n] != '>') {
            n3 = n;
            n = Dispatch.skipMyXmlIdentifier(xrefCharBuffer, n, n2);
            String string = xrefCharBuffer.substring(n3, n);
            if (xrefCharBuffer.buf[n = s.skipBlank(xrefCharBuffer, n, n2)] != '=') {
                throw new XrefException("= expected after attribute " + string);
            }
            n3 = ++n;
            n = Dispatch.skipAttribute(xrefCharBuffer, n, n2);
            String string2 = xrefCharBuffer.substring(n3, n);
            if (string.equals(Protocol.PPCA_BASE)) {
                attrBase = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_COL)) {
                attrCol = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_DEFINITION)) {
                attrDefinition = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_DEF_REFN)) {
                attrDRefn = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_INDENT)) {
                attrIndent = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_INTERFACE)) {
                attrInterface = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_LEN)) {
                attrLen = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_LINE)) {
                attrLine = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_OFFSET)) {
                attrOffset = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_REFN)) {
                attrRefn = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_SELECTED)) {
                attrSelected = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_TREE_DEPS)) {
                attrTreeDeps = Dispatch.unquote(string2);
            } else if (string.equals(Protocol.PPCA_TREE_UP)) {
                attrTreeUp = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_MTYPE)) {
                attrMType = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_TYPE)) {
                attrType = Dispatch.unquote(string2);
            } else if (string.equals(Protocol.PPCA_VALUE)) {
                attrVal = Integer.parseInt(string2);
            } else if (string.equals(Protocol.PPCA_CONTINUE)) {
                attrContinue = Integer.parseInt(string2);
            } else {
                throw new XrefException("unknown XML attribute " + string);
            }
            n = s.skipBlank(xrefCharBuffer, n, n2);
        }
        return ++n;
    }

    public static int parseXmlTagHandleMessages(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        boolean bl = true;
        while (bl) {
            Dispatch.clearAttributes();
            n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
            if (currentTag.equals(Protocol.PPC_ERROR)) {
                n = Dispatch.dispatchError(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_FATAL_ERROR)) {
                n = Dispatch.dispatchFatalError(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_WARNING)) {
                n = Dispatch.dispatchWarning(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_DEBUG_INFORMATION)) {
                n = Dispatch.dispatchDebugMessage(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_INFORMATION)) {
                n = Dispatch.dispatchMessage(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_BOTTOM_INFORMATION)) {
                n = Dispatch.dispatchBottomMessage(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_IGNORE)) {
                n = Dispatch.dispatchIgnore(xrefCharBuffer, n, n2, dispatchData);
            } else {
                bl = false;
            }
            if (!bl || (n = s.skipBlank(xrefCharBuffer, n, n2)) < n2) continue;
            bl = false;
        }
        return n;
    }

    public static int dispatchError(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_ERROR);
        throw new XrefErrorException(string);
    }

    public static int dispatchFatalError(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_FATAL_ERROR);
        throw new XrefErrorException(string);
    }

    public static int dispatchWarning(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_WARNING);
        JOptionPane.showMessageDialog(s.getProbableParent(dispatchData.callerComponent), string, "Xrefactory Warning", 2);
        return n;
    }

    public static int dispatchMessage(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_INFORMATION);
        JOptionPane.showMessageDialog(s.getProbableParent(dispatchData.callerComponent), string, "Xrefactory Info", 1);
        return n;
    }

    public static int dispatchDebugMessage(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_DEBUG_INFORMATION);
        if (s.debug) {
            JOptionPane.showMessageDialog(s.getProbableParent(dispatchData.callerComponent), string, "Xrefactory Debug Info", 1);
        }
        return n;
    }

    public static int dispatchBottomMessage(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_BOTTOM_INFORMATION);
        s.getParentView(dispatchData.callerComponent).getStatus().setMessageAndClear(string);
        return n;
    }

    public static int dispatchAskConfirmation(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_ASK_CONFIRMATION);
        int n3 = JOptionPane.showConfirmDialog(s.getProbableParent(dispatchData.callerComponent), string, "Confirmation", 0, 2);
        if (n3 != 0) {
            throw new XrefAbortException();
        }
        return n;
    }

    public static int dispatchIgnore(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_IGNORE);
        return n;
    }

    public static int dispatchFileRemove(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_FILE_REMOVE);
        int n3 = JOptionPane.showConfirmDialog(s.getProbableParent(dispatchData.callerComponent), "Can I remove the file " + string, "Confirmation", 0, 2);
        if (n3 == 0) {
            File file = new File(string);
            file.delete();
        }
        return n;
    }

    public static int dispatchFileSaveAs(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_FILE_SAVE_AS);
        s.getBuffer().save(s.view, string, true);
        try {
            Thread.currentThread();
            Thread.sleep(35L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        VFSManager.waitForRequests();
        return n;
    }

    public static int dispatchMoveDirectory(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, Protocol.PPC_STRING_VALUE);
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_STRING_VALUE);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, Protocol.PPC_STRING_VALUE);
        String string2 = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_STRING_VALUE);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_MOVE_DIRECTORY);
        int n3 = JOptionPane.showConfirmDialog(s.getProbableParent(dispatchData.callerComponent), "\tCan I move directory\n" + string + "\n\tto\n" + string2, "Confirmation", 0, 2);
        if (n3 == 0) {
            File file = new File(string);
            file.renameTo(new File(string2));
        }
        return n;
    }

    public static int dispatchMoveFileAs(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_MOVE_FILE_AS);
        File file = new File(string);
        file.getParentFile().mkdirs();
        File file2 = s.getBuffer().getFile();
        file2.delete();
        if (s.getBuffer().save(s.view, string, true)) {
            try {
                Thread.currentThread();
                Thread.sleep(35L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            VFSManager.waitForRequests();
            Buffer buffer = jEdit.getBuffer((String)file2.getAbsolutePath());
            if (buffer != null && buffer != s.getBuffer()) {
                jEdit.closeBuffer((View)s.view, (Buffer)buffer);
            }
            try {
                Thread.currentThread();
                Thread.sleep(15L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } else {
            throw new XrefException("can not move the file");
        }
        VFSManager.waitForRequests();
        return n;
    }

    public static int dispatchGoto(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        if (currentTag.equals(Protocol.PPC_OFFSET_POSITION)) {
            String string = xrefCharBuffer.substring(n, n + attrLen);
            int n3 = attrOffset;
            n += attrLen;
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
            Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_OFFSET_POSITION);
            s.moveToPosition(s.getParentView(dispatchData.callerComponent), string, n3);
        } else {
            Dispatch.protocolCheckEq(currentTag, Protocol.PPC_LC_POSITION);
            String string = xrefCharBuffer.substring(n, n + attrLen);
            int n4 = attrLine;
            int n5 = attrCol;
            n += attrLen;
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
            Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_LC_POSITION);
            s.moveToPosition(s.getParentView(dispatchData.callerComponent), string, n4, n5);
        }
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_GOTO);
        return n;
    }

    public static int dispatchPreCheck(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_REFACTORING_PRECHECK);
        Dispatch.editorPreCheck(string);
        return n;
    }

    public static int dispatchReplacement(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, Protocol.PPC_REFACTORING_REPLACE);
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_REFACTORING_REPLACE);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, Protocol.PPC_REFACTORING_REPLACE_WITH);
        String string2 = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_REFACTORING_REPLACE_WITH);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_REFACTORING_REPLACEMENT);
        Dispatch.editorReplace(string, string2);
        return n;
    }

    public static int dispatchDisplayResolution(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        boolean bl = attrContinue != 0;
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_DISPLAY_RESOLUTION);
        new ResolutionDialog(string, attrMType, dispatchData, bl);
        return n;
    }

    public static int dispatchDisplayOrUpdateBrowser(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_DISPLAY_OR_UPDATE_BROWSER);
        s.showAndUpdateBrowser(s.getParentView(dispatchData.callerComponent));
        return n;
    }

    public static int dispatchDisplayClassTree(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        XrefCharBuffer xrefCharBuffer2 = new XrefCharBuffer();
        int n3 = 1000000;
        int n4 = -1;
        int n5 = 0;
        Dispatch.clearAttributes();
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        while (currentTag.equals(Protocol.PPC_CLASS)) {
            String string;
            String string2 = xrefCharBuffer.substring(n, n + attrLen);
            n += attrLen;
            if (++n4 != 0) {
                xrefCharBuffer2.append("\n");
            }
            if (attrBase == 1) {
                string = ">>";
                if (n5 == 0) {
                    n5 = n4;
                }
            } else {
                string = "  ";
            }
            if (attrTreeUp == 1) {
                xrefCharBuffer2.append(string + attrTreeDeps + "(" + string2 + ")  ");
            } else {
                xrefCharBuffer2.append(string + attrTreeDeps + string2 + "  ");
            }
            if (n3 > attrLine) {
                n3 = attrLine;
            }
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
            Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_CLASS);
            Dispatch.clearAttributes();
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        }
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_DISPLAY_CLASS_TREE);
        new XrefClassTreeDialog(s.getParentFrame(dispatchData.callerComponent), xrefCharBuffer2.toString(), dispatchData, n3, n5);
        return n;
    }

    public static int dispatchSymbolResolution(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        Object object;
        XrefTreeNode[] xrefTreeNodeArray = new XrefTreeNode[500];
        xrefTreeNodeArray[0] = new XrefTreeNode("root", null, 0, 0, 0, false, false, false, false, false, false);
        XrefTreeNode xrefTreeNode = new XrefTreeNode("NOT MEMBER SYMBOLS", xrefTreeNodeArray[0], 0, 0, 0, false, false, false, true, false, false);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        while (currentTag.equals(Protocol.PPC_VIRTUAL_SYMBOL) || currentTag.equals(Protocol.PPC_SYMBOL)) {
            object = xrefCharBuffer.substring(n, n + attrLen);
            n += attrLen;
            if (currentTag.equals(Protocol.PPC_SYMBOL)) {
                new XrefTreeNode((String)object, xrefTreeNode, attrLine, attrRefn, attrDRefn, attrBase == 1, attrSelected == 1, attrInterface == 1, false, attrDefinition == 1, false);
                n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
                Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_SYMBOL);
                Dispatch.clearAttributes();
                n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
                continue;
            }
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
            Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_VIRTUAL_SYMBOL);
            xrefTreeNodeArray[1] = new XrefTreeNode((String)object, xrefTreeNodeArray[0], 0, 0, 0, false, false, false, true, false, false);
            Dispatch.clearAttributes();
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
            while (currentTag.equals(Protocol.PPC_CLASS)) {
                String string = xrefCharBuffer.substring(n, n + attrLen);
                n += attrLen;
                int n3 = attrIndent + 2;
                s.assertt(n3 < 500);
                xrefTreeNodeArray[n3] = new XrefTreeNode(string, xrefTreeNodeArray[n3 - 1], attrLine, attrRefn, attrDRefn, attrBase == 1, attrSelected == 1, attrInterface == 1, false, attrDefinition == 1, false);
                n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
                Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_CLASS);
                Dispatch.clearAttributes();
                n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
            }
        }
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_SYMBOL_RESOLUTION);
        if (xrefTreeNode.subNodes.size() == 0) {
            xrefTreeNodeArray[0].removeSubNode(xrefTreeNode);
        }
        s.assertt((object = s.getParentBrowserTopPanel(dispatchData.callerComponent)) != null);
        ((BrowserTopPanel)object).treePanel.xtree.setTree(xrefTreeNodeArray[0]);
        return n;
    }

    public static int dispatchReferenceList(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        boolean bl = true;
        XrefCharBuffer xrefCharBuffer2 = new XrefCharBuffer();
        int n3 = attrVal;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        while (currentTag.equals(Protocol.PPC_SRC_LINE)) {
            if (!bl) {
                xrefCharBuffer2.append("\n");
            }
            bl = false;
            int n4 = 0;
            while (n4 < attrRefn) {
                if (n4 != 0) {
                    xrefCharBuffer2.append("\n");
                }
                xrefCharBuffer2.append(xrefCharBuffer, n, attrLen);
                ++n4;
            }
            n += attrLen;
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
            Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_SRC_LINE);
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        }
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_REFERENCE_LIST);
        BrowserTopPanel browserTopPanel = s.getParentBrowserTopPanel(dispatchData.callerComponent);
        s.assertt(browserTopPanel != null);
        browserTopPanel.referencesPanel.reflist.setRefs(xrefCharBuffer2.toString(), n3);
        return n;
    }

    public static int dispatchUpdateCurrentReference(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        int n3 = attrVal;
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_UPDATE_CURRENT_REFERENCE);
        BrowserTopPanel browserTopPanel = s.getParentBrowserTopPanel(dispatchData.callerComponent);
        s.assertt(browserTopPanel != null);
        browserTopPanel.referencesPanel.reflist.setCurrentRef(n3);
        return n;
    }

    public static int dispatchProgress(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_PROGRESS);
        return n;
    }

    public static int dispatchUpdateReport(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        n += attrLen;
        Dispatch.clearAttributes();
        n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
        while (n < n2 && !currentTag.equals("/" + Protocol.PPC_UPDATE_REPORT)) {
            n += attrLen;
            Dispatch.clearAttributes();
            n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
            if (!currentTag.equals(Protocol.PPC_FATAL_ERROR)) continue;
            n = Dispatch.dispatchFatalError(xrefCharBuffer, n, n2, dispatchData);
        }
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_UPDATE_REPORT);
        return n;
    }

    public static int dispatchVersionMismatch(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_VERSION_MISMATCH);
        s.checkVersionCorrespondance(string, dispatchData);
        return n;
    }

    public static int dispatchBrowseUrl(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_BROWSE_URL);
        Dispatch.browseUrl(string, dispatchData);
        return n;
    }

    public static int dispatchSingleCompletion(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_SINGLE_COMPLETION);
        int n3 = s.getCaretPosition();
        CompletionDialog.insertCompletion(s.getBuffer(), n3, string);
        return n;
    }

    public static int dispatchFqtCompletion(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_FQT_COMPLETION);
        int n3 = s.getCaretPosition();
        CompletionDialog.insertFqtCompletion(s.getBuffer(), n3, string);
        return n;
    }

    public static int dispatchCompletionList(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        boolean bl = true;
        XrefCharBuffer xrefCharBuffer2 = new XrefCharBuffer();
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        while (currentTag.equals(Protocol.PPC_MULTIPLE_COMPLETION_LINE)) {
            if (!bl) {
                xrefCharBuffer2.append("\n");
            }
            bl = false;
            xrefCharBuffer2.append(xrefCharBuffer, n, attrLen);
            n += attrLen;
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
            Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_MULTIPLE_COMPLETION_LINE);
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        }
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_MULTIPLE_COMPLETIONS);
        new CompletionDialog(xrefCharBuffer2.toString(), dispatchData);
        return n;
    }

    public static int dispatchSymbolList(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        XrefCharBuffer xrefCharBuffer2 = new XrefCharBuffer();
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        while (currentTag.equals(Protocol.PPC_STRING_VALUE)) {
            xrefCharBuffer2.append(xrefCharBuffer, n, attrLen);
            xrefCharBuffer2.append("\n");
            n += attrLen;
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
            Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_STRING_VALUE);
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        }
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_SYMBOL_LIST);
        dispatchData.symbolList = xrefCharBuffer2;
        return n;
    }

    public static int dispatchSetProject(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        dispatchData.project = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_SET_PROJECT);
        return n;
    }

    public static int dispatchSetInfo(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        dispatchData.info = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_SET_INFO);
        return n;
    }

    public static int dispatchNoProject(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        if (dispatchData.projectCreationAllowed) {
            Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_NO_PROJECT);
            int n3 = JOptionPane.showConfirmDialog(s.getProbableParent(dispatchData.callerComponent), "No project for file " + string + ".\nCreate new project?", "No Project", 0);
            if (n3 == 0) {
                OptionsForProjectsDialog optionsForProjectsDialog = new OptionsForProjectsDialog((JFrame)s.view, true);
            }
        }
        throw new XrefAbortException();
    }

    public static int dispatchAvailableRefactorings(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        Refactorings[] refactoringsArray;
        boolean bl = true;
        Refactorings[] refactoringsArray2 = new Refactorings[24];
        int n3 = 0;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        while (currentTag.equals(Protocol.PPC_INT_VALUE)) {
            refactoringsArray = Refactorings.getRefactoringFromCode(attrVal);
            if (refactoringsArray != null) {
                s.assertt(n3 < 24);
                refactoringsArray2[n3] = refactoringsArray;
                refactoringsArray2[n3].param = xrefCharBuffer.substring(n, n + attrLen);
                ++n3;
            }
            n += attrLen;
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
            Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_INT_VALUE);
            n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        }
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_AVAILABLE_REFACTORINGS);
        refactoringsArray = new Refactorings[n3];
        System.arraycopy(refactoringsArray2, 0, refactoringsArray, 0, n3);
        new RefactoringDialog(refactoringsArray);
        return n;
    }

    public static int dispatchCopyBlock(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        int n3 = s.getCaretPosition();
        block = s.getBuffer().getText(n3, n3 + attrVal);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_REFACTORING_COPY_BLOCK);
        return n;
    }

    public static int dispatchCutBlock(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        Buffer buffer = s.getBuffer();
        int n3 = buffer.getLength();
        int n4 = s.getCaretPosition();
        if (n4 + attrVal == n3 + 1) {
            buffer.insert(n3, "\n");
        }
        block = buffer.getText(n4, attrVal);
        buffer.remove(n4, attrVal);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_REFACTORING_CUT_BLOCK);
        return n;
    }

    public static int dispatchPasteBlock(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        Buffer buffer = s.getBuffer();
        int n3 = s.getCaretPosition();
        buffer.insert(n3, block);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_REFACTORING_PASTE_BLOCK);
        return n;
    }

    public static int dispatchIndent(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        Buffer buffer = s.getBuffer();
        int n3 = s.getCaretPosition();
        int n4 = buffer.getLineOfOffset(n3);
        buffer.indentLines(n4, n4 + attrVal - 1);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_INDENT);
        return n;
    }

    public static int dispatchExtractDialog(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        n += attrLen;
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, Protocol.PPC_STRING_VALUE);
        String string = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_STRING_VALUE);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, Protocol.PPC_STRING_VALUE);
        String string2 = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_STRING_VALUE);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, Protocol.PPC_STRING_VALUE);
        String string3 = xrefCharBuffer.substring(n, n + attrLen);
        n += attrLen;
        n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_STRING_VALUE);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, Protocol.PPC_INT_VALUE);
        int n3 = attrVal;
        n += attrLen;
        n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_INT_VALUE);
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        Dispatch.protocolCheckEq(currentTag, "/" + Protocol.PPC_EXTRACTION_DIALOG);
        new ExtractMethodDialog(string, string2, string3, n3);
        return n;
    }

    public static int dispatchRecordAt(XrefCharBuffer xrefCharBuffer, int n, int n2, DispatchData dispatchData) throws Exception {
        int n3 = n = s.skipBlank(xrefCharBuffer, n, n2);
        while (xrefCharBuffer.buf[n] != '<' && n < n2) {
            ++n;
        }
        if (n != n3 && s.debug) {
            String string = xrefCharBuffer.substring(n3, n);
            JOptionPane.showMessageDialog((Component)s.view, "Unenclosed string\n" + string, "Xrefactory Error", 0);
        }
        if (n3 >= n2) {
            throw new XrefException("unexpected end of communication");
        }
        Dispatch.clearAttributes();
        n = Dispatch.parseXmlTagHandleMessages(xrefCharBuffer, n, n2, dispatchData);
        if (n < n2 && !dispatchData.panic) {
            if (currentTag.equals(Protocol.PPC_SINGLE_COMPLETION)) {
                n = Dispatch.dispatchSingleCompletion(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_FQT_COMPLETION)) {
                n = Dispatch.dispatchFqtCompletion(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_MULTIPLE_COMPLETIONS)) {
                n = Dispatch.dispatchCompletionList(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_SYMBOL_LIST)) {
                n = Dispatch.dispatchSymbolList(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_SET_PROJECT)) {
                n = Dispatch.dispatchSetProject(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_SET_INFO)) {
                n = Dispatch.dispatchSetInfo(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_NO_PROJECT)) {
                n = Dispatch.dispatchNoProject(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_UPDATE_CURRENT_REFERENCE)) {
                n = Dispatch.dispatchUpdateCurrentReference(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_BROWSE_URL)) {
                n = Dispatch.dispatchBrowseUrl(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_GOTO)) {
                n = Dispatch.dispatchGoto(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_REFACTORING_PRECHECK)) {
                n = Dispatch.dispatchPreCheck(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_REFACTORING_REPLACEMENT)) {
                n = Dispatch.dispatchReplacement(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_DISPLAY_OR_UPDATE_BROWSER)) {
                n = Dispatch.dispatchDisplayOrUpdateBrowser(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_DISPLAY_CLASS_TREE)) {
                n = Dispatch.dispatchDisplayClassTree(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_DISPLAY_RESOLUTION)) {
                n = Dispatch.dispatchDisplayResolution(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_SYMBOL_RESOLUTION)) {
                n = Dispatch.dispatchSymbolResolution(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_REFERENCE_LIST)) {
                n = Dispatch.dispatchReferenceList(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_ASK_CONFIRMATION)) {
                n = Dispatch.dispatchAskConfirmation(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_FILE_SAVE_AS)) {
                n = Dispatch.dispatchFileSaveAs(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_MOVE_FILE_AS)) {
                n = Dispatch.dispatchMoveFileAs(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_FILE_REMOVE)) {
                n = Dispatch.dispatchFileRemove(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_MOVE_DIRECTORY)) {
                n = Dispatch.dispatchMoveDirectory(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_AVAILABLE_REFACTORINGS)) {
                n = Dispatch.dispatchAvailableRefactorings(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_REFACTORING_COPY_BLOCK)) {
                n = Dispatch.dispatchCopyBlock(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_REFACTORING_CUT_BLOCK)) {
                n = Dispatch.dispatchCutBlock(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_REFACTORING_PASTE_BLOCK)) {
                n = Dispatch.dispatchPasteBlock(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_INDENT)) {
                n = Dispatch.dispatchIndent(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_EXTRACTION_DIALOG)) {
                n = Dispatch.dispatchExtractDialog(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_UPDATE_REPORT)) {
                n = Dispatch.dispatchUpdateReport(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_VERSION_MISMATCH)) {
                n = Dispatch.dispatchVersionMismatch(xrefCharBuffer, n, n2, dispatchData);
            } else if (currentTag.equals(Protocol.PPC_PROGRESS)) {
                n = Dispatch.dispatchProgress(xrefCharBuffer, n, n2, dispatchData);
            } else if (!currentTag.equals(Protocol.PPC_SYNCHRO_RECORD)) {
                throw new XrefException("unknown XML Tag " + currentTag);
            }
        }
        return n;
    }

    public static void dispatch(XrefCharBuffer xrefCharBuffer, DispatchData dispatchData) {
        if (s.debug) {
            System.err.println("Dispatching: " + xrefCharBuffer);
        }
        int n = 0;
        int n2 = xrefCharBuffer.length();
        try {
            n = s.skipBlank(xrefCharBuffer, n, n2);
            while (n < n2 && !dispatchData.panic) {
                n = Dispatch.dispatchRecordAt(xrefCharBuffer, n, n2, dispatchData);
                n = s.skipBlank(xrefCharBuffer, n, n2);
            }
        }
        catch (XrefAbortException xrefAbortException) {
            dispatchData.panic = true;
        }
        catch (XrefErrorException xrefErrorException) {
            if (s.debug) {
                xrefErrorException.printStackTrace(System.err);
            }
            JOptionPane.showMessageDialog(s.getProbableParent(dispatchData.callerComponent), xrefErrorException, "Xrefactory Error", 0);
            dispatchData.panic = true;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(s.getProbableParent(dispatchData.callerComponent), exception, "Xrefactory Internal Error", 0);
            exception.printStackTrace();
            dispatchData.panic = true;
        }
    }

    public static String reportToHtml(XrefCharBuffer xrefCharBuffer) {
        XrefCharBuffer xrefCharBuffer2 = new XrefCharBuffer();
        int n = 0;
        int n2 = xrefCharBuffer.length();
        xrefCharBuffer2.append("<html><pre>\n");
        try {
            while (n < n2) {
                Dispatch.clearAttributes();
                n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
                if (currentTag.equals(Protocol.PPC_ERROR) || currentTag.equals(Protocol.PPC_FATAL_ERROR) || currentTag.equals(Protocol.PPC_WARNING)) {
                    xrefCharBuffer2.append("<font color=red>");
                    int n3 = attrLen;
                    while (n3 > 0 && Character.isSpace(xrefCharBuffer.buf[n + n3 - 1])) {
                        --n3;
                    }
                    xrefCharBuffer2.append(xrefCharBuffer.substring(n, n + n3));
                    xrefCharBuffer2.append("</font>\n");
                    n += attrLen;
                    n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
                } else if (currentTag.equals(Protocol.PPC_INFORMATION) || currentTag.equals(Protocol.PPC_BOTTOM_INFORMATION)) {
                    xrefCharBuffer2.append("<font color=gray>");
                    xrefCharBuffer2.append(xrefCharBuffer.substring(n, n + attrLen));
                    xrefCharBuffer2.append("</font>\n");
                    n += attrLen;
                    n = Dispatch.parseXmlTag(xrefCharBuffer, n, n2);
                } else {
                    xrefCharBuffer2.append(xrefCharBuffer.substring(n, n + attrLen));
                    xrefCharBuffer2.append("\n");
                    n += attrLen;
                }
                n = s.skipBlank(xrefCharBuffer, n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog((Component)s.view, "Problem while parsing report " + exception, "Xrefactory Error", 0);
        }
        xrefCharBuffer2.append("\n</pre></html>\n");
        if (s.debug) {
            System.err.println("HTML == \n" + xrefCharBuffer2.toString());
        }
        return xrefCharBuffer2.toString();
    }
}

