/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.Refactorings;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class MoveDialog
extends JDialog {
    public String getFile() {
        return ((MovePanel)this.getContentPane()).tfile.getText();
    }

    public String getLine() {
        return ((MovePanel)this.getContentPane()).tline.getText();
    }

    public MoveDialog(String string, String string2, String string3) {
        super((Frame)s.view, "Move " + string);
        MovePanel movePanel = new MovePanel(string, string2, string3);
        this.setContentPane(movePanel);
        this.pack();
        this.setLocationRelativeTo((Component)s.view);
        this.setVisible(true);
        this.pack();
        this.repaint();
    }

    public static class MovePanel
    extends JPanel
    implements KeyListener,
    FocusListener {
        String continuationOption;
        String contTestOption;
        String stext = "";
        String sfile;
        int sline;
        int scaret;
        JTextField ssfile;
        JTextField ssline;
        JTextField tfile;
        JTextField tline;

        void actionContinue() {
            int n = s.getTextArea().getCaretLine();
            int n2 = s.getTextArea().getLineStartOffset(n);
            if (n2 != s.getTextArea().getCaretPosition()) {
                JOptionPane.showMessageDialog((Component)s.view, "Target position has to be at the begining of line, moving it.", "Xrefactory Warning", 2);
                s.getTextArea().setCaretPosition(s.getTextArea().getLineStartOffset(n));
            }
            DispatchData dispatchData = new DispatchData(s.xbTask, (Component)this);
            XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessOnFileSingleOpt(this.contTestOption, dispatchData);
            Dispatch.dispatch(xrefCharBuffer, dispatchData);
            if (!s.panic) {
                s.getParentDialog(this).setVisible(false);
                s.targetFile = this.tfile.getText();
                s.targetLine = Integer.parseInt(this.tline.getText());
                s.moveToPosition(s.view, this.sfile, this.scaret);
                if (this.stext.equals(s.getTextArea().getText())) {
                    this.stext = "";
                    if (s.targetLine > 0 && !s.targetFile.equals("")) {
                        XrefStringArray xrefStringArray = new XrefStringArray();
                        xrefStringArray.add(this.continuationOption);
                        xrefStringArray.add("-movetargetfile=" + s.targetFile);
                        xrefStringArray.add("-rfct-param1=" + s.targetLine);
                        Refactorings.mainRefactorerInvocation(xrefStringArray, false);
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)s.view, "Source file was modified during target selection, please retry.", "Xrefactory Error", 0);
                }
            }
        }

        void actionCancel() {
            s.getParentDialog(this).setVisible(false);
            this.tfile.setText("");
            this.tline.setText("0");
        }

        void actionImport() {
            this.tfile.setText(s.getBuffer().getFile().getAbsolutePath());
            this.tline.setText("" + (s.getTextArea().getCaretLine() + 1));
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                keyEvent.consume();
                this.actionCancel();
            } else if (n == 10) {
                keyEvent.consume();
                this.actionContinue();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            this.actionImport();
            s.getParentDialog(this).pack();
            s.getParentDialog(this).repaint();
        }

        MovePanel(String string, String string2, String string3) {
            JComponent[] jComponentArray = new JButton[]{new ButtonCancel(), new ButtonContinue()};
            this.continuationOption = string2;
            this.contTestOption = string3;
            this.sfile = s.getBuffer().getFile().getAbsolutePath();
            this.ssfile = new JTextField(this.sfile);
            this.ssfile.setEditable(false);
            this.ssfile.setFocusable(false);
            this.sline = s.getTextArea().getCaretLine() + 1;
            this.ssline = new JTextField("" + this.sline);
            this.ssline.setEditable(false);
            this.ssline.setFocusable(false);
            this.scaret = s.getTextArea().getCaretPosition();
            this.stext = s.getTextArea().getText();
            if (s.targetFile != null && s.targetLine > 0) {
                s.moveToPosition(s.view, s.targetFile, s.targetLine, 0);
            }
            this.tfile = new JTextField("");
            this.tfile.setEditable(false);
            this.tfile.setFocusable(false);
            this.tline = new JTextField("1");
            this.tline.setEditable(false);
            this.tline.setFocusable(false);
            this.setLayout(new GridBagLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            int n = 0;
            s.addGbcComponent(jPanel, 0, n, jComponentArray.length + 2, 1, 1, 1, 0, new JPanel());
            s.addGbcComponent(jPanel, 0, ++n, jComponentArray.length + 2, 1, 1, 1, 0, new JLabel("With current settings, Xrefactory will move " + string));
            s.addGbcComponent(jPanel, 0, ++n, jComponentArray.length + 2, 1, 1, 1, 0, new JPanel());
            s.addGbcComponent(jPanel, 0, ++n, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(jPanel, 1, n, 1, 1, 1, 1, 0, new JLabel("  from file :", 4));
            s.addGbcComponent(jPanel, 2, n, 1, 1, 1, 1, 1, this.ssfile);
            s.addGbcComponent(jPanel, 3, n, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(jPanel, 0, ++n, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(jPanel, 1, n, 1, 1, 1, 1, 0, new JLabel("   and line :", 4));
            s.addGbcComponent(jPanel, 2, n, 1, 1, 1000, 1, 1, this.ssline);
            s.addGbcComponent(jPanel, 3, n, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(jPanel, 0, ++n, jComponentArray.length + 2, 1, 1, 1, 0, new JPanel());
            s.addGbcComponent(jPanel, 0, ++n, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(jPanel, 1, n, 1, 1, 1, 1, 0, new JLabel("    to file :", 4));
            s.addGbcComponent(jPanel, 2, n, 1, 1, 1, 1, 1, this.tfile);
            s.addGbcComponent(jPanel, 3, n, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(jPanel, 0, ++n, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(jPanel, 1, n, 1, 1, 1, 1, 0, new JLabel("    on line :", 4));
            s.addGbcComponent(jPanel, 2, n, 1, 1, 1000, 1, 1, this.tline);
            s.addGbcComponent(jPanel, 3, n, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(jPanel, 0, ++n, 4, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(jPanel, 0, ++n, jComponentArray.length + 2, 1, 1, 1, 0, new JLabel("(to change the target, open the target file with jEdit and set caret on target line)"));
            int n2 = 0;
            s.addGbcComponent(this, 0, n2, jComponentArray.length + 2, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 0, ++n2, jComponentArray.length + 2, 1, 1, 1, 1, jPanel);
            s.addGbcComponent(this, 0, ++n2, jComponentArray.length + 2, 1, 1, 1, 1, new JPanel());
            s.addButtonLine(this, ++n2, jComponentArray, true);
            s.addGbcComponent(this, 0, ++n2, jComponentArray.length + 2, 1, 1, 1, 1, new JPanel());
            int n3 = 0;
            while (n3 < jComponentArray.length) {
                jComponentArray[n3].addKeyListener(this);
                jComponentArray[n3].addFocusListener(this);
                ++n3;
            }
            this.tfile.addKeyListener(this);
            this.tfile.addFocusListener(this);
            this.tline.addKeyListener(this);
            this.tline.addFocusListener(this);
            this.actionImport();
        }

        class ButtonContinue
        extends JButton
        implements ActionListener {
            ButtonContinue() {
                super("Continue");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MovePanel.this.actionContinue();
            }
        }

        class ButtonCancel
        extends JButton
        implements ActionListener {
            ButtonCancel() {
                super("Cancel");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MovePanel.this.actionCancel();
            }
        }

        class ButtonImport
        extends JButton
        implements ActionListener {
            ButtonImport() {
                super("Import position from jEdit");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MovePanel.this.actionImport();
            }
        }
    }
}

