/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefErrorException;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.JOptionPane;

class Options {
    public static final int OPT_GENERAL = 0;
    public static final int OPT_COMMON = 1;
    public static final int OPT_PROJECT = 2;
    public static final int OPT_BOTH = 3;
    public static OptionDescription optFilesCaseUnSensitive = new OptionDescription("-filescaseunsensitive", false, 0, 1, true, "File names are considered case unsensitive", "File names are considered case unsensitive", null, false, true);
    public static OptionDescription optJavaVersion = new OptionDescription("-source", true, 3, 2, false, "Sources are written in Java: ", "Java version in which sources are written.", null, false, true);
    public static OptionDescription optCSuffixes = new OptionDescription("-csuffixes=", true, 3, 2, true, "Suffixes determining C sources: ", "Identify files with those suffixes as C sources", null, true, true);
    public static OptionDescription optJavaSuffixes = new OptionDescription("-javasuffixes=", true, 3, 2, true, "Suffixes determining Java sources: ", "Identify files with those suffixes as Java sources", null, true, true);
    public static OptionDescription optProjectMarker = new OptionDescription("[", true, 2, 2, true, "Project auto detection directories: ", "Project auto detection directories", "p", false, false);
    public static OptionDescription optInputFile = new OptionDescription("", true, 2, 2, true, "Source files & directories: ", "Source files & directories", "p", false, true);
    public static OptionDescription optRecurseDirs = new OptionDescription("--r", true, 2, 1, true, "Do not descent into subdirectories when looking for input files", "Do not descent into subdirectories when looking for input files", null, true, true);
    public static OptionDescription optXrefsFile = new OptionDescription("-refs", true, 2, 2, false, "Place to store Tags: ", "Place to store Tag", "fd", false, true);
    public static OptionDescription optXrefNum = new OptionDescription("-refnum=", true, 2, 2, true, "Number of Tag files: ", "Number of Tag files", null, false, true);
    public static OptionDescription optCommentOption = new OptionDescription("//", false, 3, 0, true, "Comment", "Comment", null, false, false);
    public static OptionDescription optClassPath = new OptionDescription("-classpath", true, 3, 2, false, "Classpath: ", "Top directories with .class files (classpath)", "p", false, true);
    public static OptionDescription optSourcePath = new OptionDescription("-sourcepath", true, 3, 2, false, "Sourcepath: ", "Top directories with source code (sourcepath)", "p", false, true);
    public static OptionDescription optJavaDocPath = new OptionDescription("-javadocpath", true, 3, 2, false, "Javadocpath: ", "Top directories with javadoc documentation (javadocpath)", "p", false, false);
    public static OptionDescription optJdkClassPath = new OptionDescription("-jdkclasspath", true, 3, 2, false, "Jdk runtime library (rt.jar): ", "Jdk runtime library (rt.jar)", "p", false, true);
    public static OptionDescription optLicense = new OptionDescription("-license=", true, 1, 2, true, "License string: ", "License string", null, false, false);
    public static OptionDescription[] allOptions = new OptionDescription[]{optInputFile, optProjectMarker, optLicense, optXrefsFile, optXrefNum, optClassPath, optSourcePath, optJavaDocPath, optJdkClassPath, optJavaVersion, optCSuffixes, optJavaSuffixes, optRecurseDirs, optCommentOption, new OptionDescription("-set", false, 3, 3, false, "Set a user defined variable: ", "Set a user defined variable", "fd", false, false), new OptionDescription("-refs=", false, 2, 2, true, "Place to store Tags: ", "Place to store Tags", "fd", false, true)};
    public static final int OPTIONS_ALLOCC_CHUNK = 2;
    String projectName;
    Option[] option = new Option[0];
    int optioni = 0;
    int allocatedSize = 0;

    Options(Options options) {
        this.projectName = options.projectName;
        this.option = new Option[options.option.length];
        int n = 0;
        while (n < options.optioni) {
            this.option[n] = new Option(options.option[n]);
            ++n;
        }
        this.optioni = options.optioni;
        this.allocatedSize = options.allocatedSize;
    }

    int indexOf(Option option) {
        int n = 0;
        while (n < this.optioni) {
            if (s.stringArrayEqual(this.option[n].fulltext, option.fulltext)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    boolean contains(Option option) {
        return this.indexOf(option) != -1;
    }

    Option getContainedOption(OptionDescription optionDescription) {
        int n = 0;
        while (n < this.optioni) {
            if (this.option[n].option == optionDescription) {
                return this.option[n];
            }
            ++n;
        }
        return null;
    }

    void add(Option option) {
        if (this.optioni >= this.allocatedSize) {
            Option[] optionArray = new Option[this.allocatedSize + 2];
            System.arraycopy(this.option, 0, optionArray, 0, this.allocatedSize);
            this.option = optionArray;
            this.allocatedSize += 2;
        }
        if (option.option.addAtBeginning) {
            System.arraycopy(this.option, 0, this.option, 1, this.optioni);
            this.option[0] = option;
        } else {
            this.option[this.optioni] = option;
        }
        ++this.optioni;
    }

    void add(Option option, int n) {
        if (this.optioni >= this.allocatedSize) {
            Option[] optionArray = new Option[this.allocatedSize + 2];
            System.arraycopy(this.option, 0, optionArray, 0, this.allocatedSize);
            this.option = optionArray;
            this.allocatedSize += 2;
        }
        if (n < 0 || n >= this.optioni) {
            this.option[this.optioni] = option;
        } else {
            int n2 = this.optioni;
            while (n2 > n) {
                this.option[n2] = this.option[n2 - 1];
                --n2;
            }
            this.option[n] = option;
        }
        ++this.optioni;
    }

    void delete(int n) {
        s.assertt(this.optioni > 0);
        --this.optioni;
        int n2 = n;
        while (n2 < this.optioni) {
            this.option[n2] = this.option[n2 + 1];
            ++n2;
        }
    }

    int delete(Option option) {
        int n = this.indexOf(option);
        if (n != -1) {
            this.delete(n);
        }
        return n;
    }

    String getProjectAutoDetectionOpt() {
        int n = 0;
        while (n < this.optioni) {
            if (this.option[n].option == optProjectMarker) {
                return this.option[n].fulltext[1];
            }
            ++n;
        }
        return "";
    }

    String getOptionText(Option option) {
        String string = "";
        if (option.option.compact) {
            String string2 = "";
            int n = 0;
            while (n < option.fulltext.length) {
                string2 = string2 + option.fulltext[n];
                ++n;
            }
            string = option.option == optCommentOption ? string + string2 + "\n" : string + s.sprintOption(string2);
        } else {
            int n = 0;
            while (n < option.fulltext.length) {
                if (n != 0) {
                    string = string + " ";
                }
                string = string + s.sprintOption(option.fulltext[n]);
                ++n;
            }
        }
        return string;
    }

    public String toString(boolean bl) {
        String string = "\n";
        if (!this.projectName.equals("")) {
            string = string + "[" + this.projectName;
            String string2 = this.getProjectAutoDetectionOpt();
            if (!string2.equals("")) {
                string = string + s.classPathSeparator + string2;
            }
            string = string + "]\n  ";
        } else {
            string = string + "  ";
        }
        int n = 0;
        while (n < this.optioni) {
            if (this.option[n].option != optProjectMarker) {
                string = (string = string + this.getOptionText(this.option[n])).charAt(string.length() - 1) == '\n' ? string + "  " : string + "\n  ";
            }
            ++n;
        }
        return string;
    }

    public String toString() {
        return this.toString(false);
    }

    public static void printOptions(Options[] optionsArray, PrintStream printStream) {
        int n = 0;
        while (n < optionsArray.length) {
            printStream.println(optionsArray[n].toString());
            ++n;
        }
    }

    public static boolean projectMarkersOverlapps(String string, String string2) {
        int n;
        int n2 = string.length();
        return n2 == (n = string2.length()) ? string.equals(string2) : (n2 < n ? string.equals(string2.substring(0, n2 - 1)) && string2.substring(n2, n2 + 1).equals(s.slash) : string2.equals(string.substring(0, n - 1)) && string.substring(n, n + 1).equals(s.slash));
    }

    /*
     * Unable to fully structure code
     */
    public static String getProjectName(String var0) {
        var1_1 = new PathIterator(var0, s.classPathSeparator);
        if (var1_1.hasNext()) ** GOTO lbl7
        return "";
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.next();
            if (var2_2.length() <= 0 || var2_2.substring(0, 1).equals(s.slash)) continue;
            return var2_2;
lbl7:
            // 2 sources

            ** while (var1_1.hasNext())
        }
lbl8:
        // 1 sources

        var1_1 = new PathIterator(var0, s.classPathSeparator);
        return var1_1.next();
    }

    public static String getProjectChangeDirs(String string) {
        String string2 = Options.getProjectName(string);
        PathIterator pathIterator = new PathIterator(string, s.classPathSeparator);
        if (!pathIterator.hasNext()) {
            return "";
        }
        String string3 = "";
        while (pathIterator.hasNext()) {
            String string4 = pathIterator.next();
            if (string4.equals(string2)) continue;
            string3 = string3.equals("") ? string4 : string3 + ":" + string4;
        }
        return string3;
    }

    public static String[] getProjectNames(Options[] optionsArray, String string) {
        String[] stringArray = new String[optionsArray.length];
        int n = 0;
        while (n < optionsArray.length) {
            stringArray[n] = optionsArray[n].projectName;
            ++n;
        }
        stringArray[0] = string;
        return stringArray;
    }

    public static void saveOptions(Options[] optionsArray, String string) {
        block3: {
            PrintStream printStream = null;
            try {
                printStream = new PrintStream(new FileOutputStream(string));
                Options.printOptions(optionsArray, printStream);
                printStream.close();
            }
            catch (Exception exception) {
                if (s.debug) {
                    exception.printStackTrace(System.err);
                }
                JOptionPane.showMessageDialog((Component)s.view, "While saving options: " + exception, "Xrefactory Error", 0);
                if (printStream == null) break block3;
                printStream.close();
            }
        }
    }

    public static void dump(Options[] optionsArray) {
        Options.printOptions(optionsArray, System.err);
    }

    void addNewProjectOptions(String string, String string2, String string3, String string4) {
        this.add(new Option(optInputFile, string2));
        this.add(new Option(optXrefsFile, s.tagFilesDirectory + string));
        this.add(new Option(optXrefNum, "10"));
        this.add(new Option(optClassPath, string3));
        this.add(new Option(optSourcePath, string4));
        this.add(new Option(optJavaVersion, "1.3"));
        this.add(new Option(optCSuffixes, "c" + s.classPathSeparator + "C"));
        this.add(new Option(optJavaSuffixes, "java"));
        this.add(new Option(optJdkClassPath, s.jdkClassPath));
        String string5 = new File(s.javaHome).getParent();
        if (string5 != null) {
            this.add(new Option(optJavaDocPath, string5 + "/docs/api"));
        }
    }

    Options(String string, String string2) {
        this.projectName = string;
        this.optioni = 0;
        this.add(new Option(optProjectMarker, string2));
    }

    static class OptionParser {
        XrefCharBuffer ss;
        int sslen;
        int ind;
        public static final int MAX_PROJECTS = 1000;

        private static OptionDescription getOptionDescription(String string) {
            int n = allOptions.length - 1;
            while (n >= 0) {
                OptionDescription optionDescription = allOptions[n];
                if (optionDescription.compact && string.length() >= optionDescription.nameLen && string.substring(0, optionDescription.nameLen).equals(optionDescription.name) || !optionDescription.compact && string.equals(optionDescription.name)) {
                    return optionDescription;
                }
                --n;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        String parseOptItem() {
            block3: {
                var2_1 = this.ind = s.skipBlank(this.ss, this.ind, this.sslen);
                if (this.ind >= this.sslen || this.ss.buf[this.ind] != '\"') ** GOTO lbl11
                ++this.ind;
                while (this.ind < this.sslen && this.ss.buf[this.ind] != '\"') {
                    ++this.ind;
                }
                var1_2 = this.ss.substring(var2_1 + 1, this.ind);
                ++this.ind;
                break block3;
lbl-1000:
                // 1 sources

                {
                    ++this.ind;
lbl11:
                    // 2 sources

                    ** while (this.ind < this.sslen && !Character.isSpace((char)this.ss.buf[this.ind]))
                }
lbl12:
                // 1 sources

                var1_2 = this.ss.substring(var2_1, this.ind);
            }
            while ((var3_3 = var1_2.indexOf("${dq}")) != -1) {
                var1_2 = var1_2.substring(0, var3_3) + "\"" + var1_2.substring(var3_3 + 5);
            }
            return var1_2;
        }

        private Option parseOption() throws XrefErrorException {
            Object var2_1 = null;
            int n = this.ind = s.skipBlank(this.ss, this.ind, this.sslen);
            if (this.ind < this.sslen && this.ss.buf[this.ind] == '[') {
                while (this.ind < this.sslen && this.ss.buf[this.ind] != ']') {
                    ++this.ind;
                }
                String string = this.ss.substring(n + 1, this.ind);
                ++this.ind;
                return new Option(optProjectMarker, string);
            }
            String string = this.parseOptItem();
            OptionDescription optionDescription = OptionParser.getOptionDescription(string);
            if (optionDescription == null) {
                throw new XrefErrorException("unknown option " + string);
            }
            if (optionDescription.name.equals("//")) {
                n = this.ind;
                while (this.ind < this.sslen && this.ss.buf[this.ind] != '\n') {
                    ++this.ind;
                }
                String string2 = string.substring(2) + this.ss.substring(n, this.ind);
                return new Option(optionDescription, string2);
            }
            if (optionDescription.compact) {
                return new Option(optionDescription, string.substring(optionDescription.nameLen));
            }
            String[] stringArray = new String[optionDescription.arity - 1];
            int n2 = 1;
            while (n2 < optionDescription.arity) {
                stringArray[n2 - 1] = this.parseOptItem();
                ++n2;
            }
            return new Option(optionDescription, stringArray);
        }

        public void reParseSingleProject(Options options) throws Exception {
            options.optioni = 0;
            while (this.ind < this.sslen) {
                Option option = this.parseOption();
                if (option.option == optProjectMarker) {
                    options.add(new Option(optProjectMarker, Options.getProjectChangeDirs(option.fulltext[1])));
                } else {
                    options.add(option);
                }
                this.ind = s.skipBlank(this.ss, this.ind, this.sslen);
            }
        }

        public Options[] parseFile() throws Exception {
            Options[] optionsArray;
            Options options;
            Options[] optionsArray2 = new Options[1000];
            int n = 0;
            optionsArray2[n++] = options = new Options("", "");
            while (this.ind < this.sslen) {
                optionsArray = this.parseOption();
                if (optionsArray.option == optProjectMarker) {
                    String string = Options.getProjectName(optionsArray.fulltext[1]);
                    String string2 = Options.getProjectChangeDirs(optionsArray.fulltext[1]);
                    optionsArray2[n++] = options = new Options(string, string2);
                } else {
                    options.add((Option)optionsArray);
                }
                this.ind = s.skipBlank(this.ss, this.ind, this.sslen);
            }
            optionsArray = new Options[n];
            System.arraycopy(optionsArray2, 0, optionsArray, 0, n);
            return optionsArray;
        }

        OptionParser(File file) throws Exception {
            this.ss = new XrefCharBuffer();
            this.ss.appendFileContent(file);
            this.sslen = this.ss.length();
            this.ind = 0;
        }

        OptionParser(String string) {
            this.ss = new XrefCharBuffer(string);
            this.sslen = this.ss.length();
            this.ind = 0;
        }
    }

    static class Option {
        OptionDescription option;
        String[] fulltext;

        Option(OptionDescription optionDescription) {
            this.option = optionDescription;
            this.fulltext = new String[]{optionDescription.name};
        }

        Option(OptionDescription optionDescription, String string) {
            this.option = optionDescription;
            this.fulltext = new String[]{optionDescription.name, string};
        }

        Option(OptionDescription optionDescription, String[] stringArray) {
            this.option = optionDescription;
            this.fulltext = new String[stringArray.length + 1];
            this.fulltext[0] = optionDescription.name;
            int n = 0;
            while (n < stringArray.length) {
                this.fulltext[n + 1] = stringArray[n];
                ++n;
            }
        }

        Option(Option option) {
            this.option = option.option;
            this.fulltext = new String[option.fulltext.length];
            int n = 0;
            while (n < option.fulltext.length) {
                this.fulltext[n] = option.fulltext[n];
                ++n;
            }
        }
    }

    public static class PathIterator {
        String ss;
        int sslen;
        int i;
        String separator;

        public String next() {
            String string;
            int n = this.ss.indexOf(this.separator, this.i);
            if (n == -1) {
                string = this.ss.substring(this.i);
                this.i = this.sslen + 1;
            } else {
                string = this.ss.substring(this.i, n);
                this.i = n + 1;
            }
            return string;
        }

        public boolean hasNext() {
            return this.i < this.sslen;
        }

        public void remove() {
        }

        PathIterator(String string, String string2) {
            this.ss = string;
            this.separator = string2;
            this.sslen = string.length();
            this.i = 0;
        }
    }

    public static class OptionDescription {
        String name;
        int nameLen;
        int arity;
        boolean compact;
        String shortDescription;
        String longDescription;
        boolean interactive;
        int kind;
        boolean addAtBeginning;
        boolean recreateTagsIfModified;
        String fileSystemBrowseOptions;

        OptionDescription(String string, boolean bl, int n, int n2, boolean bl2, String string2, String string3, String string4, boolean bl3, boolean bl4) {
            this.interactive = bl;
            this.name = string;
            this.nameLen = string.length();
            this.arity = n2;
            this.kind = n;
            this.compact = bl2;
            this.shortDescription = string2;
            this.longDescription = string3;
            this.fileSystemBrowseOptions = string4;
            this.addAtBeginning = bl3;
            this.recreateTagsIfModified = bl4;
        }
    }
}

