/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.Options;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;

public class OptionsForJeditGeneral
extends AbstractOptionPane {
    static OptionsForJeditGeneral lastShowedOptions = null;
    JCheckBox completeFullyQualifiedNames;
    JCheckBox completionAccessCheck;
    JCheckBox completionLinkageCheck;
    JCheckBox fullAutoUpdate;
    JCheckBox updateBeforeRefactorings;
    JCheckBox updateBeforePush;
    JCheckBox saveFilesBeforeRefactorings;
    JCheckBox saveFilesAfterRefactorings;
    JCheckBox saveFilesAskForConfirmation;
    JCheckBox referencePushingsKeepBrowserFilter;
    JCheckBox askBeforeBrowsingJavadoc;
    JCheckBox fileNamesCaseUnSensitive;
    JComboBox maxCompletions;
    JComboBox completionDialogMaxWidth;
    JComboBox completionDialogMaxHeight;
    JComboBox activeProject;
    JTextField configurationFile;
    Options[] projects;
    Options.Option fileNamesCaseUnsensitiveOpt = new Options.Option(Options.optFilesCaseUnSensitive);

    void createActiveProjectList() {
        try {
            Options.OptionParser optionParser = new Options.OptionParser(new File(s.configurationFile));
            this.projects = optionParser.parseFile();
            this.activeProject = new JComboBox<String>(Options.getProjectNames(this.projects, "None (Automatic Project Detection)"));
            this.activeProject.setSelectedItem(Opt.activeProject());
        }
        catch (Exception exception) {
            this.projects = new Options[0];
            this.activeProject = new JComboBox();
        }
    }

    void activeProjectListRefresh(ComboBoxModel comboBoxModel) {
        int n = comboBoxModel.getSize();
        String[] stringArray = new String[n];
        stringArray[0] = "None (Automatic Project Detection)";
        int n2 = 1;
        while (n2 < n) {
            stringArray[n2] = (String)comboBoxModel.getElementAt(n2);
            ++n2;
        }
        this.activeProject.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    protected void _init() {
        s.setGlobalValues(s.getParentView((Component)((Object)this)), false);
        lastShowedOptions = this;
        this.configurationFile = new JTextField(s.configurationFile);
        this.addComponent("Projects Configuration File: ", this.configurationFile);
        this.createActiveProjectList();
        this.addComponent("The Active Project: ", this.activeProject);
        this.addComponent(new JPanel());
        this.completeFullyQualifiedNames = new JCheckBox("Completion completes fully qualified names from jar archives", Opt.completeFullyQualifiedNames());
        this.addComponent(this.completeFullyQualifiedNames);
        this.completionAccessCheck = new JCheckBox("Completion checks accessibility (public/private/protected)", Opt.completionAccessCheck());
        this.addComponent(this.completionAccessCheck);
        this.completionLinkageCheck = new JCheckBox("Completion reports only static symbols in static context.", Opt.completionLinkageCheck());
        this.addComponent(this.completionLinkageCheck);
        this.maxCompletions = new JComboBox<String>(new String[]{"100", "200", "300", "500", "1000", "2000", "3000", "5000", "10000"});
        this.maxCompletions.setEditable(true);
        this.maxCompletions.setSelectedItem("" + Opt.maxCompletions());
        this.addComponent("Maximal number of reported completions: ", this.maxCompletions);
        this.completionDialogMaxWidth = new JComboBox<String>(new String[]{"200", "400", "600", "800", "1000", "1200", "1400", "1600"});
        this.completionDialogMaxWidth.setEditable(true);
        this.completionDialogMaxWidth.setSelectedItem("" + Opt.completionDialogMaxWidth());
        this.addComponent("Completion window maximal width: ", this.completionDialogMaxWidth);
        this.completionDialogMaxHeight = new JComboBox<String>(new String[]{"100", "200", "300", "400", "500", "600", "700", "800", "900"});
        this.completionDialogMaxHeight.setEditable(true);
        this.completionDialogMaxHeight.setSelectedItem("" + Opt.completionDialogMaxHeight());
        this.addComponent("Completion window maximal height: ", this.completionDialogMaxHeight);
        this.referencePushingsKeepBrowserFilter = new JCheckBox("Keep reference filter over pushing (in browser)", Opt.referencePushingsKeepBrowserFilter());
        this.addComponent(this.referencePushingsKeepBrowserFilter);
        this.askBeforeBrowsingJavadoc = new JCheckBox("Ask for confirmation before browsing URL", Opt.askBeforeBrowsingJavadoc());
        this.addComponent(this.askBeforeBrowsingJavadoc);
        this.updateBeforePush = new JCheckBox("Update tags before pushing references", Opt.updateBeforePush());
        this.addComponent(this.updateBeforePush);
        this.fullAutoUpdate = new JCheckBox("Updating of tags provides full update (with dependencies checks)", Opt.fullAutoUpdate());
        this.addComponent(this.fullAutoUpdate);
        this.updateBeforeRefactorings = new JCheckBox("Update tags before refactoring", Opt.updateBeforeRefactorings());
        this.addComponent(this.updateBeforeRefactorings);
        this.saveFilesBeforeRefactorings = new JCheckBox("Save all modified buffers before refactoring", Opt.saveFilesBeforeRefactorings());
        this.addComponent(this.saveFilesBeforeRefactorings);
        this.saveFilesAfterRefactorings = new JCheckBox("Save all modified buffers after refactoring", Opt.saveFilesAfterRefactorings());
        this.addComponent(this.saveFilesAfterRefactorings);
        this.saveFilesAskForConfirmation = new JCheckBox("Automatic saving of buffers asks for confirmation", Opt.saveFilesAskForConfirmation());
        this.addComponent(this.saveFilesAskForConfirmation);
    }

    protected void _save() {
        if (!s.configurationFile.equals(this.configurationFile.getText())) {
            jEdit.setProperty((String)"xrefactory.configuration-file.prop", (String)this.configurationFile.getText());
            JOptionPane.showMessageDialog((Component)s.view, "You must restart jEdit in order to use new Xrefactory configuration file.", "Xrefactory Message", 1);
        }
        Opt.setActiveProject((String)this.activeProject.getSelectedItem());
        Opt.setCompleteFullyQualifiedNames(this.completeFullyQualifiedNames.isSelected());
        Opt.setCompletionAccessCheck(this.completionAccessCheck.isSelected());
        Opt.setCompletionLinkageCheck(this.completionLinkageCheck.isSelected());
        try {
            Opt.setMaxCompletions(Integer.parseInt((String)this.maxCompletions.getSelectedItem()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Opt.setCompletionDialogMaxWidth(Integer.parseInt((String)this.completionDialogMaxWidth.getSelectedItem()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Opt.setCompletionDialogMaxHeight(Integer.parseInt((String)this.completionDialogMaxHeight.getSelectedItem()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Opt.fullAutoUpdate(this.fullAutoUpdate.isSelected());
        Opt.setAskBeforeBrowsingJavadoc(this.askBeforeBrowsingJavadoc.isSelected());
        Opt.setUpdateBeforeRefactorings(this.updateBeforeRefactorings.isSelected());
        Opt.setUpdateBeforePush(this.updateBeforePush.isSelected());
        Opt.setSaveFilesBeforeRefactorings(this.saveFilesBeforeRefactorings.isSelected());
        Opt.setSaveFilesAfterRefactorings(this.saveFilesAfterRefactorings.isSelected());
        Opt.setSaveFilesAskForConfirmation(this.saveFilesAskForConfirmation.isSelected());
        Opt.setReferencePushingsKeepBrowserFilter(this.referencePushingsKeepBrowserFilter.isSelected());
        if (this.projects.length > 0) {
            boolean bl = false;
        }
    }

    public OptionsForJeditGeneral() {
        super("xrefactory-general");
    }

    class ConfigurationFileListener
    implements FocusListener {
        ConfigurationFileListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            OptionsForJeditGeneral.this.createActiveProjectList();
        }
    }
}

