/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.NewProjectDialog;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.Options;
import com.xrefactory.jedit.PathSelectionDialog;
import com.xrefactory.jedit.XrefTaskForTagFile;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OptionsForProjectsDialog
extends JDialog {
    void init(JFrame jFrame, boolean bl) {
        try {
            Options.OptionParser optionParser = new Options.OptionParser(new File(s.configurationFile));
            Options[] optionsArray = optionParser.parseFile();
            String string = "None (Automatic Project Detection)";
            if (!bl) {
                string = s.activeProject;
            }
            OptionsForProjectsSelfStandingPanel optionsForProjectsSelfStandingPanel = new OptionsForProjectsSelfStandingPanel(optionsArray, string, jFrame);
            this.setContentPane(optionsForProjectsSelfStandingPanel);
            this.pack();
            this.setSize(600, 600);
            this.setLocationRelativeTo(jFrame);
            if (bl) {
                boolean bl2 = optionsForProjectsSelfStandingPanel.panel.addNewProject(jFrame);
                if (bl2) {
                    this.setVisible(true);
                }
            } else {
                this.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public OptionsForProjectsDialog(JFrame jFrame) {
        super(jFrame);
        this.init(jFrame, false);
    }

    public OptionsForProjectsDialog(JFrame jFrame, boolean bl) {
        super(jFrame);
        this.init(jFrame, bl);
    }

    public static class OptionsForProjectsSelfStandingPanel
    extends JPanel {
        ProjectOptionsPanel panel;

        OptionsForProjectsSelfStandingPanel(Options[] optionsArray, String string, Component component) {
            int n = -1;
            JComponent[] jComponentArray = new JButton[]{new ButtonCancel(), new ButtonSave(), new ButtonClose()};
            this.setLayout(new GridBagLayout());
            this.panel = new ProjectOptionsPanel(optionsArray, string);
            s.addGbcComponent(this, 0, ++n, 1, 1, 10, 10, 2, new JPanel());
            s.addGbcComponent(this, 0, ++n, 1, 1, 1000, 1000, 1, this.panel);
            s.addGbcComponent(this, 0, ++n, 1, 1, 10, 10, 2, new JPanel());
            s.addExtraButtonLine(this, 0, ++n, 1, 1, 1, 1, jComponentArray, true);
        }

        class ButtonClose
        extends JButton
        implements ActionListener {
            ButtonClose() {
                super("Continue");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsForProjectsSelfStandingPanel.this.panel.saveProjectSettings();
                s.getProbableParent(this).setVisible(false);
            }
        }

        class ButtonSave
        extends JButton
        implements ActionListener {
            ButtonSave() {
                super("Save");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsForProjectsSelfStandingPanel.this.panel.saveProjectSettings();
            }
        }

        class ButtonCancel
        extends JButton
        implements ActionListener {
            ButtonCancel() {
                super("Cancel");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                s.getProbableParent(this).setVisible(false);
            }
        }
    }

    public static class ProjectOptionsPanel
    extends JPanel {
        public static JComboBox currentProjects = null;
        JComboBox projectsComboBox;
        Options[] projects;
        Options[] originalProjects;
        OptionsForProjectsPanel optionsPanel;
        int opy;

        void saveProjectSettings() {
            if (this.checkOptionsConsistency()) {
                Options.saveOptions(this.projects, s.configurationFile);
                this.checkProjectsModifications();
                this.originalProjects = ProjectOptionsPanel.crOptionsArrayCopy(this.projects);
            }
        }

        public boolean addNewProject(Component component) {
            NewProjectDialog newProjectDialog;
            if (component instanceof Dialog) {
                newProjectDialog = new NewProjectDialog((Dialog)component, this.projects);
            } else if (component instanceof Frame) {
                newProjectDialog = new NewProjectDialog((Frame)component, this.projects);
            } else {
                newProjectDialog = null;
                s.assertt(false);
            }
            NewProjectDialog.NewProjectPanel newProjectPanel = (NewProjectDialog.NewProjectPanel)newProjectDialog.getContentPane();
            if (!newProjectPanel.projectName.getText().equals("")) {
                int n = this.projectsComboBox.getSelectedIndex();
                Options[] optionsArray = new Options[this.projects.length + 1];
                System.arraycopy(this.projects, 0, optionsArray, 0, this.projects.length);
                optionsArray[this.projects.length] = new Options(newProjectPanel.projectName.getText(), newProjectPanel.sourceDirectory.getText());
                optionsArray[this.projects.length].addNewProjectOptions(newProjectPanel.projectName.getText(), newProjectPanel.sourceDirectory.getText(), newProjectPanel.classPath.getText(), newProjectPanel.sourcePath.getText());
                this.projects = optionsArray;
                this.projectsComboBox.addItem(newProjectPanel.projectName.getText());
                this.projectsComboBox.setSelectedIndex(this.projects.length - 1);
                JOptionPane.showMessageDialog(component, "New project was created. Please verify that remaining options are correctly set.\nIn particular that Jdk runtime library is the file storing your jdk classes (usualy rt.jar)");
                if (newProjectPanel.makeActive.isSelected()) {
                    Opt.setActiveProject(newProjectPanel.projectName.getText());
                }
                return true;
            }
            return false;
        }

        public boolean checkOptionsConsistency() {
            int n = 0;
            while (n < this.projects.length) {
                int n2 = n + 1;
                while (n2 < this.projects.length) {
                    Options.PathIterator pathIterator = new Options.PathIterator(this.projects[n].getProjectAutoDetectionOpt(), s.classPathSeparator);
                    while (pathIterator.hasNext()) {
                        String string = pathIterator.next();
                        Options.PathIterator pathIterator2 = new Options.PathIterator(this.projects[n2].getProjectAutoDetectionOpt(), s.classPathSeparator);
                        while (pathIterator2.hasNext()) {
                            String string2 = pathIterator2.next();
                            if (!Options.projectMarkersOverlapps(string, string2)) continue;
                            int n3 = JOptionPane.showOptionDialog(s.getProbableParent(this), "Conflict between projects " + this.projects[n].projectName + " and " + this.projects[n2].projectName + ".\nProjects overlap in auto detection paths: " + string + " and " + string2, "Configuration File Problem", 0, 0, null, new String[]{"Cancel", "Ignore", "Ignore All Problems"}, null);
                            if (n3 == 0) {
                                return false;
                            }
                            if (n3 != 2) continue;
                            return true;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }

        public void recreateTagFile(Options options) {
            DispatchData dispatchData = new DispatchData(s.xbTask, (Component)this);
            s.activeProject = options.projectName;
            XrefTaskForTagFile.runXrefOnTagFile("-create", "Creating Tags.", true, dispatchData);
        }

        public void checkProjectsModifications() {
            int n = 0;
            while (n < this.projects.length) {
                int n2 = 0;
                while (n2 < this.originalProjects.length) {
                    if (this.projects[n].projectName.equals(this.originalProjects[n2].projectName)) break;
                    ++n2;
                }
                if (n2 == this.originalProjects.length) {
                    int n3 = JOptionPane.showConfirmDialog(s.getProbableParent(this), "Project " + this.projects[n].projectName + " added. Can I create Tags for it?", "Xrefactory Confirmation", 0, 3);
                    if (n3 == 0) {
                        this.recreateTagFile(this.projects[n]);
                    }
                } else {
                    int n4;
                    Options options = this.projects[n];
                    Options options2 = this.originalProjects[n2];
                    int n5 = 0;
                    while (n5 < options.optioni) {
                        if (options.option[n5].option.recreateTagsIfModified && !options2.contains(options.option[n5])) break;
                        ++n5;
                    }
                    if (n5 != options.optioni && (n4 = JOptionPane.showConfirmDialog(s.getProbableParent(this), "Options in project " + options.projectName + " changed. Recreate Tags?", "Xrefactory Confirmation", 0, 3)) == 0) {
                        this.recreateTagFile(options);
                    }
                }
                ++n;
            }
        }

        OptionsForProjectsPanel crOptionsForProjectsPanel() {
            int n = this.projectsComboBox.getSelectedIndex();
            OptionsForProjectsPanel optionsForProjectsPanel = n == 0 ? new OptionsForProjectsPanel(this.projects[n], 1, Opt.optionsEditingDisplaysFile) : new OptionsForProjectsPanel(this.projects[n], 2, Opt.optionsEditingDisplaysFile);
            return optionsForProjectsPanel;
        }

        void remakeOptionsPanel() {
            OptionsForProjectsPanel optionsForProjectsPanel = this.crOptionsForProjectsPanel();
            this.remove(this.optionsPanel);
            this.optionsPanel = optionsForProjectsPanel;
            this.addOptionsPanel();
            this.revalidate();
        }

        void addOptionsPanel() {
            s.addGbcComponent(this, 0, this.opy, 6, 1, 10000, 10000, 1, this.optionsPanel);
        }

        public static Options[] crOptionsArrayCopy(Options[] optionsArray) {
            Options[] optionsArray2 = new Options[optionsArray.length];
            int n = 0;
            while (n < optionsArray.length) {
                optionsArray2[n] = new Options(optionsArray[n]);
                ++n;
            }
            return optionsArray2;
        }

        public ProjectOptionsPanel(Options[] optionsArray, String string) {
            int n = -1;
            this.projects = optionsArray;
            this.originalProjects = ProjectOptionsPanel.crOptionsArrayCopy(optionsArray);
            this.setLayout(new GridBagLayout());
            String[] stringArray = Options.getProjectNames(optionsArray, "Common Options");
            this.projectsComboBox = new JComboBox<String>(stringArray);
            if (string != null) {
                this.projectsComboBox.setSelectedItem(string);
            }
            this.projectsComboBox.addActionListener(new ComboBoxActionListener());
            this.optionsPanel = this.crOptionsForProjectsPanel();
            s.addGbcComponent(this, 0, ++n, 1, 1, 10, 1, 2, new JPanel());
            s.addGbcComponent(this, 1, n, 1, 1, 10, 1, 2, new JLabel("Project: ", 4));
            s.addGbcComponent(this, 2, n, 1, 1, 1000, 1000, 2, this.projectsComboBox);
            s.addGbcComponent(this, 3, n, 1, 1, 1, 1, 2, new ButtonNewProject());
            s.addGbcComponent(this, 4, n, 1, 1, 1, 1, 2, new ButtonDelProject());
            s.addGbcComponent(this, 5, n, 1, 1, 10, 1, 2, new JPanel());
            s.addGbcComponent(this, 0, ++n, 6, 1, 1, 1, 2, new JPanel());
            this.opy = ++n;
            this.addOptionsPanel();
            this.setSize(600, 400);
        }

        public class ComboBoxActionListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectOptionsPanel.this.remakeOptionsPanel();
            }
        }

        class ButtonShowFile
        extends JButton
        implements ActionListener {
            void updateName() {
                if (Opt.optionsEditingDisplaysFile) {
                    this.setLabel("Hide String");
                } else {
                    this.setLabel("Show String");
                }
            }

            ButtonShowFile() {
                this.updateName();
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Opt.optionsEditingDisplaysFile = !Opt.optionsEditingDisplaysFile;
                this.updateName();
                ProjectOptionsPanel.this.remakeOptionsPanel();
            }
        }

        class ButtonDelProject
        extends JButton
        implements ActionListener {
            ButtonDelProject() {
                super("Del");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ProjectOptionsPanel.this.projectsComboBox.getSelectedIndex();
                if (n == 0) {
                    JOptionPane.showMessageDialog(s.getProbableParent(this), "This project can not be deleted");
                } else {
                    int n2 = 0;
                    n2 = JOptionPane.showConfirmDialog(s.getProbableParent(this), "Really delete project " + ProjectOptionsPanel.this.projectsComboBox.getSelectedItem(), "Confirmation", 0, 3);
                    if (n2 == 0 && n > 0) {
                        Object[] objectArray = new Options[ProjectOptionsPanel.this.projects.length - 1];
                        s.arrayCopyDelElement(ProjectOptionsPanel.this.projects, objectArray, n);
                        ProjectOptionsPanel.this.projects = objectArray;
                        ProjectOptionsPanel.this.projectsComboBox.removeItemAt(n);
                        if (n < objectArray.length) {
                            ProjectOptionsPanel.this.projectsComboBox.setSelectedIndex(n);
                        } else {
                            ProjectOptionsPanel.this.projectsComboBox.setSelectedIndex(objectArray.length - 1);
                        }
                    }
                }
            }
        }

        class ButtonNewProject
        extends JButton
        implements ActionListener {
            ButtonNewProject() {
                super("New");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectOptionsPanel.this.addNewProject(s.getProbableParent(this));
            }
        }
    }

    public static class OptionsForProjectsPanel
    extends JPanel {
        boolean displayString;
        Options options;
        int kind;
        JTextArea stringOption;
        OptionsForProjectsNoFilePanel optionsPanel;

        public void addOptionsPanel() {
            s.addGbcComponent(this, 0, 0, 1, 1, 10000, 10000, 1, this.optionsPanel);
        }

        void updateStringOption() {
            int n = this.stringOption.getCaretPosition();
            this.stringOption.setText(this.options.toString());
            this.stringOption.setCaretPosition(n);
        }

        public void updateOptionsFromOptionsString() {
            block2: {
                try {
                    Options.OptionParser optionParser = new Options.OptionParser(this.stringOption.getText());
                    optionParser.reParseSingleProject(this.options);
                    this.remove(this.optionsPanel);
                    this.optionsPanel = new OptionsForProjectsNoFilePanel(this.options, this.kind);
                    this.addOptionsPanel();
                    this.revalidate();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(s.getParentDialog(this.stringOption), exception, "Xrefactory Error", 0);
                    if (!s.debug) break block2;
                    exception.printStackTrace(System.err);
                }
            }
        }

        public OptionsForProjectsPanel(Options options, int n, boolean bl) {
            JComponent jComponent;
            int n2 = -1;
            this.displayString = bl;
            this.options = options;
            this.kind = n;
            this.optionsPanel = new OptionsForProjectsNoFilePanel(options, n);
            this.stringOption = new JTextArea(options.toString());
            this.stringOption.addFocusListener(new StringOptionFocusListener());
            this.stringOption.addKeyListener(new StringOptionKeyListener());
            this.setLayout(new GridBagLayout());
            this.addOptionsPanel();
            if (bl) {
                JScrollPane jScrollPane = new JScrollPane(this.stringOption);
                jScrollPane.setMinimumSize(new Dimension(100, 80));
                jScrollPane.setPreferredSize(new Dimension(300, 200));
                jComponent = jScrollPane;
            } else {
                jComponent = new JPanel();
            }
            s.addGbcComponent(this, 0, 1, 1, 1, 100, 5000, 1, jComponent);
        }

        class StringOptionKeyListener
        implements KeyListener {
            StringOptionKeyListener() {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    OptionsForProjectsPanel.this.stringOption.insert("\n", OptionsForProjectsPanel.this.stringOption.getCaretPosition());
                    OptionsForProjectsPanel.this.updateOptionsFromOptionsString();
                    keyEvent.consume();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        }

        class StringOptionFocusListener
        implements FocusListener {
            StringOptionFocusListener() {
            }

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                OptionsForProjectsPanel.this.updateOptionsFromOptionsString();
                OptionsForProjectsPanel.this.updateStringOption();
            }
        }

        class OptionsForProjectsNoFilePanel
        extends JPanel {
            OptionsForProjectsNoFilePanel(Options options, int n) {
                int n2 = -1;
                this.setLayout(new GridBagLayout());
                ++n2;
                int n3 = 0;
                while (n3 < Options.allOptions.length) {
                    Options.OptionDescription optionDescription = Options.allOptions[n3];
                    if (optionDescription.interactive && (n == optionDescription.kind || optionDescription.kind == 3)) {
                        Object object;
                        Object object2 = null;
                        int n4 = 0;
                        while (n4 < options.optioni) {
                            object = options.option[n4];
                            if (((Options.Option)object).option == optionDescription) {
                                object2 = object;
                            }
                            ++n4;
                        }
                        object = new GraphicOption(optionDescription, (Options.Option)object2);
                        s.addGbcComponent(this, 0, n2++, 1, 1, 10000, 10000, 2, (Component)object);
                    }
                    ++n3;
                }
            }

            class GraphicOption
            extends Container {
                Options.Option option;
                JCheckBox jb;
                JTextField tf;
                ButtonBrowse bb;

                void checkBoxChanged() {
                    if (this.jb.isSelected()) {
                        ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.add(this.option);
                    } else {
                        ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.delete(this.option);
                    }
                    OptionsForProjectsPanel.this.updateStringOption();
                }

                void updateAndSelectCheckBox() {
                    String string = this.tf.getText();
                    if (this.jb.isSelected()) {
                        int n = ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.delete(this.option);
                        this.option.fulltext[1] = this.tf.getText();
                        if (string.equals("")) {
                            this.jb.setSelected(false);
                        } else {
                            ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.add(this.option, n);
                        }
                        OptionsForProjectsPanel.this.updateStringOption();
                    } else {
                        this.option.fulltext[1] = string;
                        if (!string.equals("")) {
                            this.jb.setSelected(true);
                            this.checkBoxChanged();
                        }
                    }
                    this.update(string);
                    if (!this.jb.isSelected() && !string.equals("")) {
                        this.jb.setSelected(true);
                        this.checkBoxChanged();
                    }
                }

                public void update(String string) {
                    if (this.jb.isSelected()) {
                        int n = ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.delete(this.option);
                        this.option.fulltext[1] = this.tf.getText();
                        ((OptionsForProjectsNoFilePanel)OptionsForProjectsNoFilePanel.this).OptionsForProjectsPanel.this.options.add(this.option, n);
                        OptionsForProjectsPanel.this.updateStringOption();
                    } else {
                        this.option.fulltext[1] = this.tf.getText();
                    }
                }

                GraphicOption(Options.OptionDescription optionDescription, Options.Option option) {
                    this.option = option == null ? new Options.Option(optionDescription, "") : option;
                    this.setLayout(new BoxLayout(this, 0));
                    if (optionDescription.arity == 1) {
                        this.jb = new JCheckBox(optionDescription.shortDescription);
                        this.jb.addActionListener(new checkBoxActionListener());
                        this.add(this.jb);
                    } else {
                        this.jb = new JCheckBox();
                        this.add(new JLabel(optionDescription.shortDescription));
                    }
                    if (option != null) {
                        this.jb.setSelected(true);
                    }
                    if (optionDescription.arity > 1) {
                        s.assertt(optionDescription.arity == 2);
                        this.tf = new JTextField(this.option.fulltext[1]);
                        this.tf.setPreferredSize(new Dimension(300, 20));
                        this.add(this.tf);
                        this.tf.addFocusListener(new TextFieldFocusListener());
                        this.tf.addKeyListener(new TextFieldKeyListener());
                    }
                    if (optionDescription.fileSystemBrowseOptions != null) {
                        this.bb = new ButtonBrowse();
                        this.bb.browseMode = optionDescription.fileSystemBrowseOptions;
                        this.add(this.bb);
                    }
                }

                class TextFieldFocusListener
                implements FocusListener {
                    TextFieldFocusListener() {
                    }

                    public void focusGained(FocusEvent focusEvent) {
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        GraphicOption.this.updateAndSelectCheckBox();
                    }
                }

                class TextFieldKeyListener
                implements KeyListener {
                    TextFieldKeyListener() {
                    }

                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            GraphicOption.this.updateAndSelectCheckBox();
                            keyEvent.consume();
                        }
                    }

                    public void keyReleased(KeyEvent keyEvent) {
                    }

                    public void keyTyped(KeyEvent keyEvent) {
                    }
                }

                class checkBoxActionListener
                implements ActionListener {
                    checkBoxActionListener() {
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        GraphicOption.this.checkBoxChanged();
                    }
                }

                class ButtonBrowse
                extends JButton
                implements ActionListener {
                    String browseMode;

                    ButtonBrowse() {
                        super("Browse");
                        this.addActionListener(this);
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = this.browseMode.toLowerCase();
                        if (string.equals("d") || string.equals("f") || string.equals("fd")) {
                            JFileChooser jFileChooser = new JFileChooser();
                            int n = string.equals("d") ? 1 : (string.equals("f") ? 0 : 2);
                            jFileChooser.setFileSelectionMode(n);
                            jFileChooser.setApproveButtonText("Select");
                            int n2 = jFileChooser.showOpenDialog(s.getParentDialog(this));
                            GraphicOption.this.tf.setText(jFileChooser.getSelectedFile().getPath());
                        } else if (string.equals("p")) {
                            PathSelectionDialog pathSelectionDialog = new PathSelectionDialog(s.getParentDialog(this), GraphicOption.this.tf.getText());
                            GraphicOption.this.tf.setText(pathSelectionDialog.resultString);
                        }
                        GraphicOption.this.updateAndSelectCheckBox();
                    }
                }
            }
        }
    }
}

