/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.AWTPump;
import com.xrefactory.jedit.s;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class Progress
extends JDialog {
    ProgressPanel panel;
    Component parent;

    public boolean setProgress(int n) {
        this.panel.setProgress(n);
        this.paint(this.getGraphics());
        if (!this.isVisible()) {
            return false;
        }
        AWTPump.pumpEventsForHierarchy(s.getParentDialog(this));
        return this.isVisible();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.dispose();
            return true;
        }
        return super.handleEvent(event);
    }

    public static Progress crNew(Component component, String string) {
        Progress progress;
        JDialog jDialog = s.getParentDialog(component);
        if (jDialog != null) {
            progress = new Progress((Dialog)jDialog, string);
        } else {
            JFrame jFrame = s.getParentFrame(component);
            progress = new Progress((Frame)jFrame, string);
        }
        return progress;
    }

    void init(Component component, String string) {
        this.parent = component;
        this.panel = new ProgressPanel(string);
        this.setContentPane(this.panel);
        this.pack();
        this.setLocationRelativeTo(component);
        this.setVisible(true);
    }

    Progress(Dialog dialog, String string) {
        super(dialog, "Progress");
        this.init(dialog, string);
    }

    Progress(Frame frame, String string) {
        super(frame, "Progress");
        this.init(frame, string);
    }

    public static class ProgressPanel
    extends JPanel {
        private int count;
        private int max;
        ProgressBar bar;

        void setProgress(int n) {
            this.count = n;
        }

        ProgressPanel(String string) {
            int n = -1;
            JComponent[] jComponentArray = new JButton[]{new ButtonCancel()};
            this.bar = new ProgressBar(100);
            this.setLayout(new GridBagLayout());
            s.addGbcComponent(this, 0, ++n, 3, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 1, ++n, 1, 1, 1, 1, 1, new JLabel(string));
            s.addGbcComponent(this, 0, ++n, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 1, n, 1, 1, 100, 1, 1, this.bar);
            s.addGbcComponent(this, 2, n, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 0, ++n, 3, 1, 1, 1, 1, new JPanel());
            s.addExtraButtonLine(this, 0, ++n, 3, 1, 1, 1, jComponentArray, true);
            s.addGbcComponent(this, 0, ++n, 3, 1, 1, 1, 1, new JPanel());
        }

        class ButtonCancel
        extends JButton
        implements ActionListener {
            ButtonCancel() {
                super("Cancel");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                s.getParentDialog(this).setVisible(false);
            }
        }

        public class ProgressBar
        extends JPanel {
            public void paint(Graphics graphics) {
                Dimension dimension = this.getSize();
                double d = (double)ProgressPanel.this.count * 100.0 / (double)ProgressPanel.this.max;
                int n = (dimension.width - 2) * ProgressPanel.this.count / ProgressPanel.this.max;
                graphics.setColor(Color.red);
                graphics.fillRect(1, 1, n, dimension.height - 2);
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }

            public ProgressBar(int n) {
                ProgressPanel.this.count = 0;
                ProgressPanel.this.max = n;
                this.setLayout(null);
                this.addNotify();
                this.setPreferredSize(new Dimension(400, 10));
            }
        }
    }
}

