/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.Push;
import com.xrefactory.jedit.SymbolRetriever;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefSelectableLinesTextPanel;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PushSymbolDialog
extends JDialog {
    void init(Component component, DispatchData dispatchData) {
        this.setTitle("Xrefactory");
        PushSymbolPanel pushSymbolPanel = new PushSymbolPanel(dispatchData, s.getIdentifierOnCaret());
        this.setContentPane(pushSymbolPanel);
        this.setSize(400, 150);
        this.setLocationRelativeTo(component);
        this.setModal(true);
        this.setVisible(true);
    }

    public PushSymbolDialog(JDialog jDialog, DispatchData dispatchData) {
        super(jDialog);
        this.init(jDialog, dispatchData);
    }

    public PushSymbolDialog(JFrame jFrame, DispatchData dispatchData) {
        super(jFrame);
        this.init(jFrame, dispatchData);
    }

    public static class PushSymbolPanel
    extends JPanel {
        JComboBox symbol;
        DispatchData data;
        static XrefStringArray history = new XrefStringArray();

        PushSymbolPanel(DispatchData dispatchData, String string) {
            int n = -1;
            this.data = dispatchData;
            this.setLayout(new GridBagLayout());
            JComponent[] jComponentArray = new JButton[]{new ButtonCancel(), new ButtonPush()};
            if (!history.getLast().equals(string)) {
                history.add(string);
            }
            this.symbol = new JComboBox<String>(history.toStringArray(false));
            this.symbol.setEditable(true);
            this.symbol.setSelectedItem(string);
            s.addGbcComponent(this, 1, ++n, 4, 1, 1, 1, 1, new JLabel("Symbol to push on reference stack", 0));
            s.addGbcComponent(this, 0, ++n, 1, 1, 1, 1, 2, new JPanel());
            s.addGbcComponent(this, 1, n, 1, 1, 1000, 1, 2, this.symbol);
            s.addGbcComponent(this, 2, n, 1, 1, 1, 1, 2, new ButtonBrowse());
            s.addGbcComponent(this, 3, n, 1, 1, 1, 1, 2, new JPanel());
            s.addGbcComponent(this, 0, ++n, 4, 1, 1, 1, 1, new JPanel());
            s.addExtraButtonLine(this, 0, ++n, 4, 1, 1, 1, jComponentArray, true);
            s.addGbcComponent(this, 0, ++n, 4, 1, 1, 1, 1, new JPanel());
        }

        class ButtonBrowse
        extends JButton
        implements ActionListener {
            ButtonBrowse() {
                super("Retrieve");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SymbolRetriever symbolRetriever = (SymbolRetriever)s.getParentView(PushSymbolPanel.this.data.callerComponent).getDockableWindowManager().getDockable("xrefactory.retriever");
                if (symbolRetriever != null) {
                    symbolRetriever.setResult(new XrefCharBuffer(), PushSymbolPanel.this.data);
                }
                DispatchData dispatchData = new DispatchData(PushSymbolPanel.this.data, (Component)this);
                XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessOnFile(new String[]{"-searchdefshortlist", "-olcxtagsearch="}, dispatchData);
                Dispatch.dispatch(xrefCharBuffer, dispatchData);
                if (dispatchData.symbolList != null && !dispatchData.panic) {
                    JDialog jDialog = new JDialog((Dialog)s.getParentDialog(this), true);
                    if (s.javaVersion.compareTo("1.4.0") >= 0) {
                        jDialog.setUndecorated(true);
                    }
                    XrefSelectableLinesTextPanel xrefSelectableLinesTextPanel = new XrefSelectableLinesTextPanel(dispatchData.symbolList.toString(), dispatchData, "", 1, 0);
                    jDialog.setContentPane(new JScrollPane(xrefSelectableLinesTextPanel));
                    Rectangle rectangle = PushSymbolPanel.this.getBounds(null);
                    jDialog.setSize((int)rectangle.getWidth(), 200);
                    jDialog.setLocationRelativeTo(s.getParentDialog(this));
                    jDialog.setLocation(jDialog.getX() + 5, this.getY() + s.getParentDialog(this).getY() + 50);
                    jDialog.setVisible(true);
                    PushSymbolPanel.this.symbol.setSelectedItem(xrefSelectableLinesTextPanel.result);
                }
            }
        }

        class ButtonPush
        extends JButton
        implements ActionListener {
            ButtonPush() {
                super("Push");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                s.getParentDialog(this).setVisible(false);
                String string = (String)PushSymbolPanel.this.symbol.getSelectedItem();
                if (!history.getLast().equals(string)) {
                    history.add(string);
                }
                DispatchData dispatchData = new DispatchData(PushSymbolPanel.this.data, (Component)this);
                new Push(new String[]{"-olcxpushname=" + string, "-olnodialog"}, dispatchData);
            }
        }

        class ButtonCancel
        extends JButton
        implements ActionListener {
            ButtonCancel() {
                super("Cancel");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                s.getParentDialog(this).setVisible(false);
            }
        }
    }
}

