/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.AddParameterDialog;
import com.xrefactory.jedit.DelParameterDialog;
import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.MoveDialog;
import com.xrefactory.jedit.MoveParameterDialog;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.RenameDialog;
import com.xrefactory.jedit.TurnDynamicToStaticDialog;
import com.xrefactory.jedit.TurnStaticToDynamicDialog;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.XrefTaskForTagFile;
import com.xrefactory.jedit.XrefactorerTask;
import com.xrefactory.jedit.s;
import java.awt.Component;
import javax.swing.JOptionPane;

public abstract class Refactorings {
    String param;
    static boolean running;

    abstract int getCode();

    public abstract String toString();

    void perform() {
        if (s.debug) {
            new Exception().printStackTrace(System.err);
        }
        JOptionPane.showMessageDialog((Component)s.view, "Not yet implemented", "Xrefactory Error", 0);
    }

    public static Refactorings getRefactoringFromCode(int n) {
        Refactorings refactorings = null;
        switch (n) {
            case 0: {
                refactorings = new No_refactoring();
                break;
            }
            case 1: {
                refactorings = new Rename_symbol();
                break;
            }
            case 2: {
                refactorings = new Rename_class();
                break;
            }
            case 3: {
                refactorings = new Rename_package();
                break;
            }
            case 4: {
                refactorings = new Add_parameter();
                break;
            }
            case 5: {
                refactorings = new Del_parameter();
                break;
            }
            case 6: {
                refactorings = new Move_parameter();
                break;
            }
            case 7: {
                refactorings = new Extract_method();
                break;
            }
            case 8: {
                refactorings = new Extract_macro();
                break;
            }
            case 9: {
                refactorings = new Move_static_field();
                break;
            }
            case 10: {
                refactorings = new Move_static_method();
                break;
            }
            case 11: {
                refactorings = new Move_field();
                break;
            }
            case 12: {
                refactorings = new Pull_up_field();
                break;
            }
            case 13: {
                refactorings = new Pull_up_method();
                break;
            }
            case 14: {
                refactorings = new Push_down_field();
                break;
            }
            case 15: {
                refactorings = new Push_down_method();
                break;
            }
            case 16: {
                refactorings = new Move_class();
                break;
            }
            case 17: {
                refactorings = new Encapsulate_field();
                break;
            }
            case 18: {
                refactorings = new Self_encapsulate_field();
                break;
            }
            case 19: {
                refactorings = new Turn_dynamic_method_to_static();
                break;
            }
            case 20: {
                refactorings = new Turn_static_method_to_dynamic();
                break;
            }
            case 21: {
                refactorings = new Reduce_names();
                break;
            }
            case 22: {
                refactorings = new Expand_names();
                break;
            }
            case 23: {
                refactorings = new Set_move_target();
                break;
            }
            default: {
                refactorings = null;
                JOptionPane.showMessageDialog((Component)s.view, "Unknown refactoring code: " + n, "Xrefactory Internal Error", 0);
            }
        }
        return refactorings;
    }

    public static void renameSymbol(String string) {
        if (string != null) {
            XrefStringArray xrefStringArray = new XrefStringArray();
            xrefStringArray.add("-rfct-rename");
            xrefStringArray.add("-renameto=" + string);
            Refactorings.mainRefactorerInvocation(xrefStringArray, false);
        }
    }

    public static void renameClass(String string, boolean bl) {
        if (string != null) {
            XrefStringArray xrefStringArray = new XrefStringArray();
            xrefStringArray.add("-rfct-rename-class");
            xrefStringArray.add("-renameto=" + string);
            Refactorings.mainRefactorerInvocation(xrefStringArray, bl);
        }
    }

    public static void mainRefactorerInvocation(XrefStringArray xrefStringArray, boolean bl) {
        RefactoringsRunnable refactoringsRunnable = new RefactoringsRunnable(xrefStringArray);
        if (bl) {
            refactoringsRunnable.run();
        } else {
            refactoringsRunnable.run();
        }
    }

    static class RefactoringsRunnable
    implements Runnable {
        XrefStringArray runOptions;
        static boolean running;
        static XrefactorerTask activeProcess;

        public static boolean passCheckForRunningProcess() {
            while (running) {
                int n = JOptionPane.showConfirmDialog((Component)s.view, "A refactoring process is running, kill it?", "Xrefactory", 1);
                if (n == 0) {
                    if (activeProcess == null) continue;
                    activeProcess.killThis(false);
                    continue;
                }
                if (n != 2) continue;
                return false;
            }
            return true;
        }

        public void run() {
            if (!RefactoringsRunnable.passCheckForRunningProcess()) {
                return;
            }
            running = true;
            String string = null;
            if (Opt.saveFilesBeforeRefactorings()) {
                s.saveAllBuffers(s.view);
            }
            if (Opt.updateBeforeRefactorings()) {
                boolean bl = s.synchronizedUpdateTagFile((Component)s.view);
                if (bl) {
                    running = false;
                    return;
                }
            } else if (!XrefTaskForTagFile.passCheckForRunningProcess("Tags are currently being created or updated. Can I kill this process?", (Component)s.view)) {
                running = false;
                return;
            }
            if ((string = s.activeProject) != null) {
                XrefStringArray xrefStringArray = new XrefStringArray();
                DispatchData dispatchData = new DispatchData((Component)s.view);
                xrefStringArray.add("-p");
                xrefStringArray.add(string);
                xrefStringArray.add(this.runOptions);
                xrefStringArray.add("-user");
                xrefStringArray.add(s.getViewParameter(dispatchData.viewId));
                activeProcess = new XrefactorerTask(xrefStringArray);
                dispatchData.xTask = activeProcess;
                dispatchData.progressMessage = "Computing patches.";
                XrefCharBuffer xrefCharBuffer = activeProcess.getTaskOutput(dispatchData);
                new ApplyRefactoring(xrefCharBuffer, dispatchData).run();
            }
            running = false;
        }

        RefactoringsRunnable(XrefStringArray xrefStringArray) {
            this.runOptions = xrefStringArray;
        }
    }

    static class ApplyRefactoring
    implements Runnable {
        XrefCharBuffer receipt;
        DispatchData ndata;

        public void run() {
            Dispatch.dispatch(this.receipt, this.ndata);
            if (!this.ndata.panic && Opt.saveFilesAfterRefactorings()) {
                s.saveAllBuffers(s.view);
            }
        }

        ApplyRefactoring(XrefCharBuffer xrefCharBuffer, DispatchData dispatchData) {
            this.receipt = xrefCharBuffer;
            this.ndata = dispatchData;
        }
    }

    public static class Set_move_target
    extends Refactorings {
        int getCode() {
            return 23;
        }

        public String toString() {
            return "Set Move Target";
        }
    }

    public static class Expand_names
    extends Refactorings {
        int getCode() {
            return 22;
        }

        public String toString() {
            return "Expand Names";
        }

        void perform() {
            XrefStringArray xrefStringArray = new XrefStringArray();
            xrefStringArray.add("-rfct-expand");
            Refactorings.mainRefactorerInvocation(xrefStringArray, false);
        }
    }

    public static class Reduce_names
    extends Refactorings {
        int getCode() {
            return 21;
        }

        public String toString() {
            return "Reduce Names";
        }

        void perform() {
            XrefStringArray xrefStringArray = new XrefStringArray();
            xrefStringArray.add("-rfct-reduce");
            Refactorings.mainRefactorerInvocation(xrefStringArray, false);
        }
    }

    public static class Turn_static_method_to_dynamic
    extends Refactorings {
        int getCode() {
            return 20;
        }

        public String toString() {
            return "Turn Static Method to Virtual";
        }

        void perform() {
            String string = s.getIdentifierOnCaret();
            new TurnStaticToDynamicDialog(string);
        }
    }

    public static class Turn_dynamic_method_to_static
    extends Refactorings {
        int getCode() {
            return 19;
        }

        public String toString() {
            return "Turn Virtual Method to Static";
        }

        void perform() {
            String string = s.getIdentifierOnCaret();
            new TurnDynamicToStaticDialog(string);
        }
    }

    public static class Self_encapsulate_field
    extends Refactorings {
        int getCode() {
            return 18;
        }

        public String toString() {
            return "Self Encapsulate Field";
        }
    }

    public static class Encapsulate_field
    extends Refactorings {
        int getCode() {
            return 17;
        }

        public String toString() {
            return "Encapsulate Field";
        }
    }

    public static class Push_down_method
    extends Refactorings {
        int getCode() {
            return 15;
        }

        public String toString() {
            return "Push Down Method";
        }
    }

    public static class Push_down_field
    extends Refactorings {
        int getCode() {
            return 14;
        }

        public String toString() {
            return "Push Down Field";
        }
    }

    public static class Pull_up_method
    extends Refactorings {
        int getCode() {
            return 13;
        }

        public String toString() {
            return "Pull Up Method";
        }
    }

    public static class Pull_up_field
    extends Refactorings {
        int getCode() {
            return 12;
        }

        public String toString() {
            return "Pull Up Field";
        }
    }

    public static class Move_field
    extends Refactorings {
        int getCode() {
            return 11;
        }

        public String toString() {
            return "Move Field";
        }
    }

    public static class Move_class
    extends Refactorings {
        int getCode() {
            return 16;
        }

        public String toString() {
            return "Move Class";
        }

        void perform() {
            String string = s.getIdentifierOnCaret();
            new MoveDialog("class '" + string + "'", "-rfct-move-class", "-olcxmctarget");
        }
    }

    public static class Move_static_method
    extends Refactorings {
        MoveDialog d;

        int getCode() {
            return 10;
        }

        public String toString() {
            return "Move Static Method";
        }

        void perform() {
            String string = s.getIdentifierOnCaret();
            new MoveDialog("static method '" + string + "'", "-rfct-move-static-method", "-olcxmmtarget");
        }
    }

    public static class Move_static_field
    extends Refactorings {
        MoveDialog d;

        int getCode() {
            return 9;
        }

        public String toString() {
            return "Move Static Field";
        }

        void perform() {
            String string = s.getIdentifierOnCaret();
            new MoveDialog("static field '" + string + "'", "-rfct-move-static-field", "-olcxmmtarget");
        }
    }

    public static class Extract_macro
    extends Refactorings {
        int getCode() {
            return 8;
        }

        public String toString() {
            return "Extract Macro";
        }
    }

    public static class Extract_method
    extends Refactorings {
        int getCode() {
            return 7;
        }

        public String toString() {
            return "Extract Method";
        }

        void perform() {
            XrefStringArray xrefStringArray = new XrefStringArray();
            xrefStringArray.add("-rfct-extract-method");
            Refactorings.mainRefactorerInvocation(xrefStringArray, true);
            if (s.xExtractMethod != null) {
                String string = s.getBuffer().getLineText(s.xExtractMethod.definitionLine - 1);
                System.err.println("testing " + string);
                int n = string.indexOf("newMethod$(");
                if (n != -1) {
                    s.moveToPosition(s.view, s.getFileName(), s.xExtractMethod.definitionLine, n);
                    Refactorings.renameSymbol(s.xExtractMethod.name.getText());
                } else {
                    n = string.indexOf("NewMethod$");
                    if (n != -1) {
                        s.moveToPosition(s.view, s.getFileName(), s.xExtractMethod.definitionLine, n);
                        Refactorings.renameClass(s.upperCaseFirstLetter(s.xExtractMethod.name.getText()), true);
                        String string2 = s.getBuffer().getLineText(s.xExtractMethod.invocationLine - 1);
                        n = string2.indexOf("newMethod$");
                        if (n != -1) {
                            s.moveToPosition(s.view, s.getFileName(), s.xExtractMethod.invocationLine, n);
                            Refactorings.renameSymbol(s.lowerCaseFirstLetter(s.xExtractMethod.name.getText()));
                        }
                    }
                }
            }
        }
    }

    public static class Move_parameter
    extends Refactorings {
        int getCode() {
            return 6;
        }

        public String toString() {
            return "Move Parameter";
        }

        void perform() {
            MoveParameterDialog moveParameterDialog = new MoveParameterDialog(s.getIdentifierOnCaret());
            int n = Integer.parseInt(moveParameterDialog.getPosition());
            int n2 = Integer.parseInt(moveParameterDialog.getPosition2());
            if (n > 0 && n2 > 0) {
                XrefStringArray xrefStringArray = new XrefStringArray();
                xrefStringArray.add("-rfct-move-param");
                xrefStringArray.add("-olcxparnum=" + n);
                xrefStringArray.add("-olcxparnum2=" + n2);
                Refactorings.mainRefactorerInvocation(xrefStringArray, false);
            }
        }
    }

    public static class Del_parameter
    extends Refactorings {
        int getCode() {
            return 5;
        }

        public String toString() {
            return "Delete Parameter";
        }

        void perform() {
            DelParameterDialog delParameterDialog = new DelParameterDialog(s.getIdentifierOnCaret());
            int n = Integer.parseInt(delParameterDialog.getPosition());
            if (n > 0) {
                XrefStringArray xrefStringArray = new XrefStringArray();
                xrefStringArray.add("-rfct-del-param");
                xrefStringArray.add("-olcxparnum=" + n);
                Refactorings.mainRefactorerInvocation(xrefStringArray, false);
            }
        }
    }

    public static class Add_parameter
    extends Refactorings {
        int getCode() {
            return 4;
        }

        public String toString() {
            return "Add Parameter";
        }

        void perform() {
            AddParameterDialog addParameterDialog = new AddParameterDialog(s.getIdentifierOnCaret());
            int n = Integer.parseInt(addParameterDialog.getPosition());
            String string = addParameterDialog.getDefinition();
            String string2 = addParameterDialog.getUsage();
            if (n > 0 && !string.equals("") && !string2.equals("")) {
                XrefStringArray xrefStringArray = new XrefStringArray();
                xrefStringArray.add("-rfct-add-param");
                xrefStringArray.add("-olcxparnum=" + n);
                xrefStringArray.add("-rfct-param1=" + string);
                xrefStringArray.add("-rfct-param2=" + string2);
                Refactorings.mainRefactorerInvocation(xrefStringArray, false);
            }
        }
    }

    public static class Rename_package
    extends Refactorings {
        int getCode() {
            return 3;
        }

        public String toString() {
            return "Rename Package";
        }

        void perform() {
            RenameDialog renameDialog = new RenameDialog("package", s.dotifyString(this.param));
            String string = renameDialog.getNewName();
            if (string != null) {
                XrefStringArray xrefStringArray = new XrefStringArray();
                xrefStringArray.add("-rfct-rename-package");
                xrefStringArray.add("-renameto=" + string);
                Refactorings.mainRefactorerInvocation(xrefStringArray, false);
            }
        }
    }

    public static class Rename_class
    extends Refactorings {
        int getCode() {
            return 2;
        }

        public String toString() {
            return "Rename Class";
        }

        void perform() {
            RenameDialog renameDialog = new RenameDialog("class", s.getIdentifierOnCaret());
            String string = renameDialog.getNewName();
            Refactorings.renameClass(string, false);
        }
    }

    public static class Rename_symbol
    extends Refactorings {
        int getCode() {
            return 1;
        }

        public String toString() {
            return "Rename";
        }

        void perform() {
            RenameDialog renameDialog = new RenameDialog("symbol", s.getIdentifierOnCaret());
            String string = renameDialog.getNewName();
            Refactorings.renameSymbol(string);
        }
    }

    public static class No_refactoring
    extends Refactorings {
        int getCode() {
            return 0;
        }

        public String toString() {
            return "No Refactoring";
        }

        void perform() {
        }
    }
}

