/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.XrefErrorException;
import java.io.File;
import java.io.FileReader;

public class XrefCharBuffer {
    static final int ALLOCATION_UNIT_SIZE = 4096;
    public char[] buf = new char[4096];
    public int buflen = 4096;
    public int bufi = 0;

    void increaseSize(long l) {
        if ((long)this.bufi + l >= (long)this.buflen) {
            int n = this.buflen;
            while ((long)this.bufi + l >= (long)n) {
                n *= 2;
            }
            char[] cArray = new char[n];
            System.arraycopy(this.buf, 0, cArray, 0, this.bufi);
            this.buflen = n;
            this.buf = cArray;
        }
    }

    public int length() {
        return this.bufi;
    }

    public char lastChar() {
        if (this.bufi > 0) {
            return this.buf[this.bufi - 1];
        }
        return '\u0000';
    }

    public void append(char[] cArray, int n) {
        this.increaseSize(n);
        System.arraycopy(cArray, 0, this.buf, this.bufi, n);
        this.bufi += n;
    }

    public void append(String string) {
        int n = string.length();
        this.increaseSize(n);
        string.getChars(0, n, this.buf, this.bufi);
        this.bufi += n;
    }

    public void append(XrefCharBuffer xrefCharBuffer, int n, int n2) {
        this.increaseSize(n2);
        System.arraycopy(xrefCharBuffer.buf, n, this.buf, this.bufi, n2);
        this.bufi += n2;
    }

    public String toString() {
        return new String(this.buf, 0, this.bufi);
    }

    public String substring(int n, int n2) {
        return new String(this.buf, n, n2 - n);
    }

    public void appendFileContent(File file) throws Exception {
        long l = file.length();
        if (l > 0L) {
            this.increaseSize(l);
            FileReader fileReader = new FileReader(file);
            int n = fileReader.read(this.buf, this.bufi, this.buflen);
            fileReader.close();
            if ((long)n != l) {
                throw new XrefErrorException("file " + file.getName() + " of size " + l + " but read only " + n + " bytes");
            }
            this.bufi += n;
        }
    }

    public void clear() {
        this.bufi = 0;
    }

    public XrefCharBuffer() {
    }

    public XrefCharBuffer(String string) {
        this();
        this.append(string);
    }
}

