/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefTreeCellRenderer;
import com.xrefactory.jedit.XrefTreeKeyAdapter;
import com.xrefactory.jedit.XrefTreeModel;
import com.xrefactory.jedit.XrefTreeMouseAdapter;
import com.xrefactory.jedit.XrefTreeMouseMotionAdapter;
import com.xrefactory.jedit.XrefTreeNode;
import com.xrefactory.jedit.XrefTreePath;
import com.xrefactory.jedit.XrefTreeSelectionListener;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeSelectionModel;

public class XrefCtree
extends JTree {
    private static XrefTreeNode[] aa = new XrefTreeNode[500];
    DispatchData data;
    public XrefTreeNode tree;
    public XrefTreeNode active;

    private void expandAndSelect(XrefTreeNode xrefTreeNode, int n) {
        XrefCtree.aa[n] = xrefTreeNode;
        XrefTreePath xrefTreePath = new XrefTreePath(aa, n + 1);
        this.expandPath(xrefTreePath);
        if (xrefTreeNode.selected) {
            this.addSelectionPath(xrefTreePath);
        }
        Enumeration enumeration = xrefTreeNode.children();
        while (enumeration.hasMoreElements()) {
            this.expandAndSelect((XrefTreeNode)enumeration.nextElement(), n + 1);
        }
    }

    public void expandAndSelect() {
        this.expandAndSelect(this.tree, 0);
    }

    public void selectUnselect(XrefTreeNode xrefTreeNode, int n, boolean bl) {
        XrefCtree.aa[n] = xrefTreeNode;
        xrefTreeNode.selected = bl;
        Enumeration enumeration = xrefTreeNode.children();
        while (enumeration.hasMoreElements()) {
            this.selectUnselect((XrefTreeNode)enumeration.nextElement(), n + 1, bl);
        }
    }

    public void selectUnselectAll(boolean bl) {
        this.selectUnselect(this.tree, 0, bl);
        this.treeDidChange();
        String string = bl ? "-olcxmenuall" : "-olcxmenunone";
        DispatchData dispatchData = new DispatchData(this.data, (Component)this);
        XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessSingleOpt(string, dispatchData);
        Dispatch.dispatch(xrefCharBuffer, dispatchData);
    }

    void callProcessOnTreeLine(String string) {
        DispatchData dispatchData = new DispatchData(this.data, (Component)this);
        XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessSingleOpt(string + this.active.printedOnLine, dispatchData);
        Dispatch.dispatch(xrefCharBuffer, dispatchData);
    }

    public void toggleSelection() {
        this.active.selected = !this.active.selected;
        this.callProcessOnTreeLine("-olcxmenuselect");
        this.treeDidChange();
    }

    public void setTree(XrefTreeNode xrefTreeNode) {
        super.setModel(new XrefTreeModel(xrefTreeNode));
        this.tree = xrefTreeNode;
        this.active = null;
        this.expandAndSelect();
        this.repaint();
    }

    XrefCtree(DispatchData dispatchData) {
        this(new XrefTreeNode(), dispatchData);
    }

    XrefCtree(XrefTreeNode xrefTreeNode, DispatchData dispatchData) {
        this.data = dispatchData;
        this.setTree(xrefTreeNode);
        this.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.setSelectionModel(defaultTreeSelectionModel);
        this.expandAndSelect();
        XrefTreeCellRenderer xrefTreeCellRenderer = new XrefTreeCellRenderer();
        this.setCellRenderer(xrefTreeCellRenderer);
        this.setRootVisible(false);
        this.addMouseListener(new XrefTreeMouseAdapter(this));
        this.addMouseMotionListener(new XrefTreeMouseMotionAdapter(this));
        this.addKeyListener(new XrefTreeKeyAdapter());
        this.addTreeSelectionListener(new XrefTreeSelectionListener(this));
    }
}

