/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.XrefCharBuffer;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTextArea;

class XrefRefListArea
extends JTextArea {
    DispatchData data;
    int lastSelectedLine = -1;

    void renewSelection() {
        try {
            int n = this.getCaretPosition();
            int n2 = this.getLineOfOffset(n);
            if (n2 != this.lastSelectedLine) {
                this.lastSelectedLine = n2;
                DispatchData dispatchData = new DispatchData(this.data, (Component)this);
                XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessSingleOpt("-olcxgoto" + (n2 + 1), dispatchData);
                Dispatch.dispatch(xrefCharBuffer, dispatchData);
            }
            this.setCaretPosition(this.getLineEndOffset(n2) - 1);
            this.moveCaretPosition(this.getLineStartOffset(n2));
            this.getCaret().setSelectionVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void previous() {
        try {
            int n = this.getCaretPosition();
            int n2 = this.getLineOfOffset(n);
            int n3 = this.getLineStartOffset(n2);
            this.moveCaretPosition(n3 - 1);
            this.renewSelection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void next() {
        try {
            int n = this.getCaretPosition();
            int n2 = this.getLineOfOffset(n);
            int n3 = this.getLineEndOffset(n2);
            this.moveCaretPosition(n3 + 1);
            this.renewSelection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void highlightReference(int n) {
        try {
            this.moveCaretPosition(this.getLineStartOffset(n) + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastSelectedLine = n;
        this.renewSelection();
    }

    public void setCurrentRef(int n) {
        this.highlightReference(n);
    }

    public void setRefs(String string, int n) {
        this.setText(string);
        this.repaint();
        this.highlightReference(n);
    }

    XrefRefListArea(DispatchData dispatchData) {
        this("", dispatchData);
    }

    XrefRefListArea(String string, DispatchData dispatchData) {
        super(string);
        this.data = dispatchData;
        this.setEditable(false);
        MouseAdapter mouseAdapter = new MouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.addKeyListener(mouseAdapter);
    }

    class MouseAdapter
    extends java.awt.event.MouseAdapter
    implements MouseMotionListener,
    KeyListener {
        MouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            XrefRefListArea.this.lastSelectedLine = -1;
            XrefRefListArea.this.renewSelection();
            mouseEvent.consume();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            XrefRefListArea.this.renewSelection();
            mouseEvent.consume();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 38) {
                XrefRefListArea.this.previous();
                keyEvent.consume();
            } else if (n == 40) {
                XrefRefListArea.this.next();
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            XrefRefListArea.this.renewSelection();
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

