/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.event.MouseInputAdapter;

public class XrefSelectableLinesTextPanel
extends JTextArea {
    DispatchData data;
    int lineOffset;
    int lastSelectedLine = -1;
    String inspectOption;
    String result = "";

    void renewSelection() {
        try {
            int n = this.getCaretPosition();
            int n2 = this.getLineOfOffset(n);
            if (n2 != this.lastSelectedLine) {
                this.lastSelectedLine = n2;
            }
            this.setCaretPosition(this.getLineEndOffset(n2) - 1);
            this.moveCaretPosition(this.getLineStartOffset(n2));
            this.getCaret().setSelectionVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void inspectLine() {
        try {
            int n = this.getCaretPosition();
            int n2 = this.getLineOfOffset(n);
            this.result = this.getText(this.getLineStartOffset(n2), this.getLineEndOffset(n2) - this.getLineStartOffset(n2) - 1);
            if (this.inspectOption != null && !this.inspectOption.equals("")) {
                DispatchData dispatchData = new DispatchData(this.data, (Component)this);
                XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessSingleOpt(this.inspectOption + (n2 + this.lineOffset), dispatchData);
                Dispatch.dispatch(xrefCharBuffer, dispatchData);
                this.renewSelection();
            } else {
                s.getProbableParent(this).setVisible(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Dimension countPreferredSize() {
        int n = this.getLineCount();
        int n2 = n * this.getRowHeight();
        if (n2 >= 300) {
            return new Dimension(500, 300);
        }
        return new Dimension(500, n2);
    }

    public int getCaretLineShiftOffset() {
        try {
            int n = this.getCaretPosition();
            int n2 = this.getLineOfOffset(n);
            return (n2 + 1) * this.getRowHeight();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    XrefSelectableLinesTextPanel(String string, DispatchData dispatchData, String string2, int n, int n2) {
        super(string);
        this.data = dispatchData;
        this.lineOffset = n;
        this.inspectOption = string2;
        this.setEditable(false);
        this.setBackground(s.LIGHT_GRAY);
        XrefClassTreeMouseAdapter xrefClassTreeMouseAdapter = new XrefClassTreeMouseAdapter();
        this.addMouseListener(xrefClassTreeMouseAdapter);
        this.addMouseMotionListener(xrefClassTreeMouseAdapter);
        this.addKeyListener(xrefClassTreeMouseAdapter);
        try {
            this.setCaretPosition(this.getLineStartOffset(n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    XrefSelectableLinesTextPanel(String string) {
        this("", null, string, 1, 0);
    }

    class XrefClassTreeMouseAdapter
    extends MouseInputAdapter
    implements KeyListener {
        XrefClassTreeMouseAdapter() {
        }

        void moveSelection(MouseEvent mouseEvent) {
            int n = mouseEvent.getY();
            int n2 = XrefSelectableLinesTextPanel.super.getRowHeight();
            try {
                XrefSelectableLinesTextPanel.this.setCaretPosition(XrefSelectableLinesTextPanel.this.getLineStartOffset(n / n2));
                XrefSelectableLinesTextPanel.this.renewSelection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            XrefSelectableLinesTextPanel.this.inspectLine();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.moveSelection(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.moveSelection(mouseEvent);
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                XrefSelectableLinesTextPanel.this.result = "";
                JDialog jDialog = s.getParentDialog(XrefSelectableLinesTextPanel.this);
                if (jDialog != null) {
                    jDialog.setVisible(false);
                }
            } else if (n == 10 || n == 32) {
                XrefSelectableLinesTextPanel.this.inspectLine();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            XrefSelectableLinesTextPanel.this.renewSelection();
            keyEvent.consume();
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

