/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.Progress;
import com.xrefactory.jedit.Protocol;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.Selection;

public class XrefTask {
    public boolean killed = false;
    public Process pp = null;
    public OutputStream oo = null;
    public InputStream ii = null;
    public boolean restartable = true;
    XrefStringArray startingOption = new XrefStringArray();
    XrefStringArray tmpOption = new XrefStringArray();
    Progress progress = null;
    LinkedList temporaryFiles = new LinkedList();
    File xrefOutputFile;
    boolean keepOutputFile = false;

    public void killThis(boolean bl) {
        this.killed = true;
        if (s.debug) {
            System.err.println("killing the process");
        }
        if (this.progress != null) {
            this.progress.setVisible(false);
            this.progress = null;
        }
        if (this.pp != null) {
            this.pp.destroy();
            this.pp = null;
            if (bl) {
                SwingUtilities.invokeLater(new s.MessageDisplayer("Xrefactory task killed", true));
            }
        } else if (bl) {
            SwingUtilities.invokeLater(new s.MessageDisplayer("No task to kill", true));
        }
        if (this.oo != null) {
            try {
                this.oo.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.oo = null;
        }
        if (this.ii != null) {
            try {
                this.ii.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ii = null;
        }
        try {
            this.deleteXrefOutputFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.removeTemporaryFiles();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startThis() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        XrefStringArray xrefStringArray = new XrefStringArray();
        xrefStringArray.add(s.xrefTaskPath);
        xrefStringArray.add("-xrefactory-II");
        xrefStringArray.add("-xrefrc=" + s.configurationFile);
        xrefStringArray.add("-crlfconversion");
        xrefStringArray.add("-crconversion");
        xrefStringArray.add(this.startingOption);
        String[] stringArray = xrefStringArray.toCmdArray();
        if (s.debug) {
            String string = "";
            int n = 0;
            while (n < stringArray.length) {
                string = string + stringArray[n] + " ";
                ++n;
            }
            System.err.println(string);
        }
        this.pp = runtime.exec(stringArray);
        this.oo = this.pp.getOutputStream();
        this.ii = this.pp.getInputStream();
        this.killed = false;
    }

    public void saveEditedBufferToTemporaryFile(Buffer buffer, String string) {
        try {
            buffer.save(s.view, string, false);
            File file = new File(string);
            this.temporaryFiles.add(new TmpBufferFile(buffer, file));
        }
        catch (Exception exception) {
            if (s.debug) {
                exception.printStackTrace(System.err);
            }
            JOptionPane.showMessageDialog((Component)s.view, "While saving tmp files: " + exception, "Xrefactory Error", 0);
        }
    }

    void deleteXrefOutputFile() {
        if (this.xrefOutputFile != null && this.xrefOutputFile.exists() && !s.debug) {
            this.xrefOutputFile.delete();
        }
    }

    void removeTemporaryFiles() {
        if (!this.keepOutputFile) {
            this.deleteXrefOutputFile();
        }
        while (!this.temporaryFiles.isEmpty()) {
            TmpBufferFile tmpBufferFile = (TmpBufferFile)this.temporaryFiles.getFirst();
            this.temporaryFiles.removeFirst();
            if (s.debug) continue;
            tmpBufferFile.savedAsFile.delete();
        }
    }

    void passeBufferThrougTmpFile(XrefStringArray xrefStringArray, Buffer buffer) {
        File file = s.getNewTmpFileName();
        String string = file.getAbsolutePath();
        xrefStringArray.add("-preload");
        xrefStringArray.add(buffer.getFile().getAbsolutePath());
        xrefStringArray.add(string);
        this.saveEditedBufferToTemporaryFile(buffer, string);
    }

    public synchronized void addModifiedFilesOptions(XrefStringArray xrefStringArray, boolean bl) {
        Buffer[] bufferArray = jEdit.getBuffers();
        Buffer buffer = s.getBuffer();
        int n = 0;
        while (n < bufferArray.length) {
            if (bufferArray[n].isDirty() && (bufferArray[n] != buffer || bl)) {
                this.passeBufferThrougTmpFile(xrefStringArray, bufferArray[n]);
            }
            ++n;
        }
        VFSManager.waitForRequests();
    }

    public synchronized void addCurrentFileOptions(XrefStringArray xrefStringArray) {
        Selection selection = s.getTextArea().getSelectionAtOffset(s.getTextArea().getCaretPosition());
        this.passeBufferThrougTmpFile(xrefStringArray, s.getBuffer());
        VFSManager.waitForRequests();
        xrefStringArray.add(s.getBuffer().getFile().getAbsolutePath());
        if (selection == null) {
            xrefStringArray.add("-olcursor=" + s.getTextArea().getCaretPosition());
            xrefStringArray.add("-olmark=" + s.getTextArea().getCaretPosition());
        } else {
            xrefStringArray.add("-olcursor=" + selection.getEnd());
            xrefStringArray.add("-olmark=" + selection.getStart());
        }
    }

    public void addFileProcessingOptions(XrefStringArray xrefStringArray) {
        this.addModifiedFilesOptions(xrefStringArray, false);
        this.addCurrentFileOptions(xrefStringArray);
    }

    void sendDataToRunningProcess(String string) throws IOException {
        if (s.debug) {
            System.err.println("sending " + string);
        }
        PrintStream printStream = new PrintStream(this.oo);
        printStream.println(string);
        this.oo.flush();
        if (s.debug) {
            System.err.println("sent");
        }
    }

    public XrefCharBuffer getTaskOutput(DispatchData dispatchData) {
        XrefCharBuffer xrefCharBuffer = new XrefCharBuffer();
        int n = 32;
        boolean bl = true;
        try {
            while (bl) {
                xrefCharBuffer.clear();
                while (n != -1 && Character.isSpace((char)n)) {
                    n = this.ii.read();
                }
                while (n != -1 && bl) {
                    xrefCharBuffer.append("" + (char)n);
                    if (s.debug) {
                        System.err.println("got : " + n + "==" + (char)n);
                    }
                    if (n == 62) {
                        bl = false;
                    }
                    n = this.ii.read();
                }
                bl = false;
                if (xrefCharBuffer.toString().equals("<" + Protocol.PPC_PROGRESS + ">")) {
                    boolean bl2 = true;
                    int n2 = 0;
                    while (n != -1 && bl2) {
                        if (n >= 48 && n <= 57) {
                            n2 = n2 * 10 + n - 48;
                        } else {
                            bl2 = false;
                        }
                        n = this.ii.read();
                    }
                    if (s.debug) {
                        System.err.println("progress == " + n2);
                    }
                    if (this.progress == null) {
                        this.progress = Progress.crNew(dispatchData.callerComponent, dispatchData.progressMessage);
                    }
                    if (s.debug) {
                        System.err.println("setting progress to " + n2);
                    }
                    if (!this.progress.setProgress(n2)) {
                        this.killThis(true);
                        bl = false;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (!xrefCharBuffer.toString().equals("<" + Protocol.PPC_SYNCHRO_RECORD + ">")) {
                    if (this.killed) {
                        xrefCharBuffer.clear();
                    } else {
                        if (this.pp != null) {
                            this.pp.destroy();
                        }
                        if (this.ii != null) {
                            while (n != -1) {
                                xrefCharBuffer.append("" + (char)n);
                                n = this.ii.read();
                            }
                        }
                        if (s.debug) {
                            System.err.println("kill due to synchro problem");
                        }
                        new Exception().printStackTrace(System.err);
                        JOptionPane.showMessageDialog(s.getProbableParent(dispatchData.callerComponent), "Internal Error, synchro problem: " + xrefCharBuffer.toString(), "Xrefactory Error", 0);
                        xrefCharBuffer.clear();
                        if (s.debug) {
                            xrefCharBuffer.appendFileContent(this.xrefOutputFile);
                        }
                        this.killThis(false);
                    }
                } else {
                    xrefCharBuffer.clear();
                    xrefCharBuffer.appendFileContent(this.xrefOutputFile);
                    this.deleteXrefOutputFile();
                    this.removeTemporaryFiles();
                }
                if (this.progress == null) continue;
                this.progress.setVisible(false);
                this.progress = null;
            }
        }
        catch (Exception exception) {
            if (s.debug) {
                exception.printStackTrace();
            }
            JOptionPane.showMessageDialog(s.getProbableParent(dispatchData.callerComponent), "Communication problem: " + exception, "Xrefactory Error", 0);
        }
        return xrefCharBuffer;
    }

    public synchronized XrefCharBuffer callProcess(XrefStringArray xrefStringArray, DispatchData dispatchData) {
        String string = null;
        XrefCharBuffer xrefCharBuffer = new XrefCharBuffer();
        boolean bl = false;
        string = xrefStringArray.toString();
        string = string + " end-of-options\n";
        try {
            if (this.pp == null && this.restartable) {
                this.startThis();
            }
            this.sendDataToRunningProcess(string);
        }
        catch (Exception exception) {
            if (!this.restartable) {
                if (s.debug) {
                    exception.printStackTrace();
                }
                JOptionPane.showMessageDialog(s.getProbableParent(dispatchData.callerComponent), "Internal Error: process exited " + exception, "Xrefactory Error", 0);
                return xrefCharBuffer;
            }
            this.killThis(false);
            try {
                this.startThis();
                this.sendDataToRunningProcess(string);
            }
            catch (Exception exception2) {
                this.killThis(false);
                if (s.debug) {
                    exception2.printStackTrace();
                }
                JOptionPane.showMessageDialog(s.getProbableParent(dispatchData.callerComponent), "Internal Error: can't start process: " + exception2, "Xrefactory Error", 0);
                if (s.debug) {
                    exception.printStackTrace();
                }
                return xrefCharBuffer;
            }
        }
        xrefCharBuffer = this.getTaskOutput(dispatchData);
        return xrefCharBuffer;
    }

    public static void addCommonOptions(XrefStringArray xrefStringArray, DispatchData dispatchData) {
        xrefStringArray.add("-user");
        xrefStringArray.add(s.getViewParameter(dispatchData.viewId));
        String string = Opt.activeProject();
        if (!string.equals("None (Automatic Project Detection)")) {
            xrefStringArray.add("-p");
            xrefStringArray.add(string);
        }
    }

    public XrefCharBuffer callProcessOnFile(XrefStringArray xrefStringArray, DispatchData dispatchData) {
        XrefCharBuffer xrefCharBuffer = new XrefCharBuffer();
        Object var4_4 = null;
        Object var5_5 = null;
        try {
            XrefStringArray xrefStringArray2 = new XrefStringArray(xrefStringArray);
            this.addFileProcessingOptions(xrefStringArray2);
            XrefTask.addCommonOptions(xrefStringArray2, dispatchData);
            xrefCharBuffer = this.callProcess(xrefStringArray2, dispatchData);
        }
        catch (Exception exception) {
            if (s.debug) {
                exception.printStackTrace();
            }
            JOptionPane.showMessageDialog((Component)s.view, "Internal Error while passing file to task: " + exception, "Xrefactory Error", 0);
        }
        return xrefCharBuffer;
    }

    public XrefCharBuffer callProcess(String[] stringArray, DispatchData dispatchData) {
        this.tmpOption.clear();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                this.tmpOption.add(stringArray[n]);
            }
            ++n;
        }
        XrefTask.addCommonOptions(this.tmpOption, dispatchData);
        return this.callProcess(this.tmpOption, dispatchData);
    }

    public XrefCharBuffer callProcessSingleOpt(String string, DispatchData dispatchData) {
        return this.callProcess(new String[]{string}, dispatchData);
    }

    public XrefCharBuffer callProcessOnFileNoSaves(String[] stringArray, DispatchData dispatchData) {
        this.tmpOption.clear();
        int n = 0;
        while (n < stringArray.length) {
            this.tmpOption.add(stringArray[n]);
            ++n;
        }
        XrefTask.addCommonOptions(this.tmpOption, dispatchData);
        this.addCurrentFileOptions(this.tmpOption);
        return this.callProcess(this.tmpOption, dispatchData);
    }

    public XrefCharBuffer callProcessOnFile(String[] stringArray, DispatchData dispatchData) {
        this.tmpOption.clear();
        int n = 0;
        while (n < stringArray.length) {
            this.tmpOption.add(stringArray[n]);
            ++n;
        }
        return this.callProcessOnFile(this.tmpOption, dispatchData);
    }

    public XrefCharBuffer callProcessOnFileSingleOpt(String string, DispatchData dispatchData) {
        this.tmpOption.clear();
        if (string != null) {
            this.tmpOption.add(string);
        }
        return this.callProcessOnFile(this.tmpOption, dispatchData);
    }

    static class TmpBufferFile {
        Buffer buffer;
        File savedAsFile;

        TmpBufferFile(Buffer buffer, File file) {
            this.buffer = buffer;
            this.savedAsFile = file;
        }
    }
}

