/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.XrefCtree;
import com.xrefactory.jedit.XrefTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class XrefTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    public static EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
    public static Font normalFont = null;
    public static Font boldFont = null;
    public static Font italicFont = null;
    public static Font italicBoldFont = null;
    public static Font topLevelFont = null;

    XrefTreeCellRenderer() {
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        XrefTreeNode xrefTreeNode = (XrefTreeNode)object;
        String string = " " + xrefTreeNode.className;
        if (xrefTreeNode.bestFit && !xrefTreeNode.isTopLevel) {
            string = xrefTreeNode.className + " *";
        }
        if (xrefTreeNode.refNum + xrefTreeNode.drefNum > 0) {
            string = xrefTreeNode.drefNum > 0 && xrefTreeNode.refNum > 0 ? string + "   (" + xrefTreeNode.drefNum + "+" + xrefTreeNode.refNum + ")" : string + "   (" + (xrefTreeNode.refNum + xrefTreeNode.drefNum) + ")";
        }
        JComponent jComponent = xrefTreeNode.isTopLevel ? new JTextArea("\n" + string) : new JCheckBox(string, xrefTreeNode.selected);
        jComponent.setBorder(emptyBorder);
        if (normalFont == null) {
            normalFont = new Font(jComponent.getFont().getName(), 0, jComponent.getFont().getSize());
        }
        if (boldFont == null) {
            boldFont = new Font(jComponent.getFont().getName(), 1, jComponent.getFont().getSize());
        }
        if (italicFont == null) {
            italicFont = new Font(jComponent.getFont().getName(), 2, jComponent.getFont().getSize());
        }
        if (italicBoldFont == null) {
            italicBoldFont = new Font(jComponent.getFont().getName(), 3, jComponent.getFont().getSize());
        }
        if (xrefTreeNode.hasdefinition && xrefTreeNode.isinterface) {
            jComponent.setFont(italicBoldFont);
        } else if (xrefTreeNode.hasdefinition) {
            jComponent.setFont(boldFont);
        } else if (xrefTreeNode.isinterface) {
            jComponent.setFont(italicFont);
        } else {
            jComponent.setFont(normalFont);
        }
        jComponent.setBackground(jTree.getBackground());
        if (xrefTreeNode.isTopLevel) {
            if (xrefTreeNode.className == "NOT MEMBER SYMBOLS") {
                jComponent.setFont(boldFont);
                jComponent.setForeground(Color.lightGray);
            } else {
                jComponent.setFont(boldFont);
                jComponent.setForeground(Color.red);
            }
        } else {
            jComponent.setForeground(Color.black);
        }
        if (bl) {
            if (((XrefCtree)jTree).active != null) {
                ((XrefCtree)jTree).active.active = false;
            }
            xrefTreeNode.active = true;
            ((XrefCtree)jTree).active = xrefTreeNode;
        }
        if (xrefTreeNode.active && !xrefTreeNode.isTopLevel) {
            jComponent.setForeground(Color.blue);
        }
        return jComponent;
    }
}

