/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.BrowserPanel;
import com.xrefactory.jedit.BrowserTask;
import com.xrefactory.jedit.BrowserTopPanel;
import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.ExtractMethodDialog;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.Options;
import com.xrefactory.jedit.Progress;
import com.xrefactory.jedit.Protocol;
import com.xrefactory.jedit.ResolutionPanel;
import com.xrefactory.jedit.TagReportDialog;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefTaskForTagFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HelpViewer;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class s {
    public static boolean debug = false;
    public static final String xrefTaskDirUrl = "http://www.xref-tech.com/xrefactory/downloads/jedit/";
    public static final String dockableBrowserWindowName = "xrefactory.browser";
    public static final String dockableRetrieverWindowName = "xrefactory.retriever";
    public static final String tryInstallXrefOption = "xrefactory.try-install-xref.prop";
    public static final String configurationFileOption = "xrefactory.configuration-file.prop";
    public static final String projectAutoDetectionName = "None (Automatic Project Detection)";
    public static final String answerNoAndDoNotAskAnymore = "No and do not display this dialog anymore";
    public static final String xrefTmpFilesPrefix = "xrefactory";
    public static final String xrefTmpFilesSuffix = ".tmp";
    public static final String xrefLogFileSingleName = "xrefactory.log";
    public static String tagFilesDirectory = "/";
    public static String tagProcessingReportFile = null;
    public static final int XREF_MAX_TREE_DEEP = 500;
    public static final int XREF_DOWNLOAD_BUFFER_SIZE = 1024;
    public static final String XREF_UN_VIRTUALS_NAME = "NOT MEMBER SYMBOLS";
    public static View view;
    public static String activeProject;
    public static BrowserTopPanel xbrowser;
    public static HelpViewer xHelpViewer;
    public static ExtractMethodDialog.ExtractMethodPanel xExtractMethod;
    public static String targetFile;
    public static int targetLine;
    public static boolean panic;
    public static boolean xrefTaskYetChecked;
    public static BrowserTask xbTask;
    public static String xrefTaskUrl;
    public static String rootDir;
    public static String slash;
    public static String classPathSeparator;
    public static String pluginInstallationPath;
    public static String tmpDirectoryPath;
    public static String osName;
    public static String archName;
    public static String jdkClassPath;
    public static String javaHome;
    public static String homeDir;
    public static String configurationFile;
    public static String xrefTaskPath;
    public static String javaVersion;
    public static int currentTmpFileCounter;
    public static int tmpFileStep;
    public static final int OS_OTHER = 0;
    public static final int OS_WINDOWS = 1;
    public static int osCode;
    public static Color LIGHT_GRAY;
    private static GridBagConstraints gbc;

    public static File getNewTmpFileName() {
        File file;
        s.assertt(tmpFileStep != 0);
        do {
            file = new File(tmpDirectoryPath + xrefTmpFilesPrefix + currentTmpFileCounter + xrefTmpFilesSuffix);
            currentTmpFileCounter += tmpFileStep;
        } while (file.exists());
        return file;
    }

    public static void cleanOldTmpFiles() {
        int n;
        File file = new File(tmpDirectoryPath);
        File[] fileArray = file.listFiles(new tmpFileNameFilter(172800000L));
        if (fileArray.length > 0 && (n = JOptionPane.showConfirmDialog(null, "There are some old temporary files generated by Xrefactory, can I delete them?", "Xrefactory temporary files", 0)) == 0) {
            fileArray = file.listFiles(new tmpFileNameFilter(86400000L));
            int n2 = 0;
            while (n2 < fileArray.length) {
                fileArray[n2].delete();
                ++n2;
            }
        }
    }

    public static boolean browserIsDisplayed() {
        return view.getDockableWindowManager().isDockableWindowVisible(dockableBrowserWindowName);
    }

    public static boolean browserIsDisplayed(Component component) {
        View view = s.getParentView(component);
        return view.getDockableWindowManager().isDockableWindowVisible(dockableBrowserWindowName);
    }

    public static BrowserTopPanel getBrowser(View view) {
        BrowserPanel browserPanel = (BrowserPanel)view.getDockableWindowManager().getDockable(dockableBrowserWindowName);
        if (browserPanel != null) {
            return browserPanel.top;
        }
        return xbrowser;
    }

    public static void beforePushBrowserFiltersUpdates() {
        Opt.browserTreeFilter = 2;
        if (!Opt.referencePushingsKeepBrowserFilter()) {
            Opt.browserRefListFilter = 0;
        }
    }

    public static void browserNeedsToUpdate(View view) {
        BrowserTopPanel browserTopPanel = s.getBrowser(view);
        if (browserTopPanel != null) {
            browserTopPanel.needToUpdate();
        }
    }

    public static void showAndUpdateBrowser(View view) {
        view.getDockableWindowManager().showDockableWindow(dockableBrowserWindowName);
        s.browserNeedsToUpdate(view);
    }

    public static String getFileName() {
        return view.getBuffer().getFile().getAbsolutePath();
    }

    public static int getCaretPosition() {
        return view.getTextArea().getCaretPosition();
    }

    public static JEditTextArea getTextArea() {
        return view.getTextArea();
    }

    public static Buffer getBuffer() {
        return view.getBuffer();
    }

    public static String inferDefaultSourcePath() {
        char c;
        int n;
        File file = s.getBuffer().getFile().getParentFile();
        String string = file.getAbsolutePath();
        String string2 = s.getTextArea().getText();
        if (string2.substring(0, 7).equals("package")) {
            n = "package".length();
        } else {
            n = string2.indexOf("\npackage");
            if (n == -1) {
                return string;
            }
            n += "\npackage".length();
        }
        while (Character.isSpaceChar(string2.charAt(n))) {
            ++n;
        }
        int n2 = n;
        int n3 = 0;
        while (Character.isLetterOrDigit(c = string2.charAt(n2)) || Character.isSpaceChar(c) || c == '.') {
            if (Character.isLetterOrDigit(c) || c == '.') {
                ++n3;
            }
            ++n2;
        }
        if (n3 >= string.length()) {
            return string;
        }
        int n4 = string.length() - n3;
        while (file.getAbsolutePath().length() > n4) {
            file = file.getParentFile();
        }
        return file.getAbsolutePath();
    }

    public static void fileSetExecPermission(String string) {
        if (osName.toLowerCase().indexOf("linux") != -1 || osName.toLowerCase().indexOf("unix") != -1 || osName.toLowerCase().indexOf("sunos") != -1 || osName.toLowerCase().indexOf("mac os x") != -1) {
            String[] stringArray = new String[]{"chmod", "a+x", string};
            try {
                Runtime.getRuntime().exec(stringArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void downloadXrefTask(String string, String string2) {
        if (debug) {
            System.err.println("Downloading " + string + " into " + string2);
        }
        Progress progress = Progress.crNew(null, "Downloading xref task");
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = new URL(string).openConnection();
            inputStream = uRLConnection.getInputStream();
            File file = new File(string2);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            int n = 0;
            int n2 = uRLConnection.getContentLength();
            int n3 = 1;
            while (n3 >= 0) {
                n3 = inputStream.read(byArray, 0, 1024);
                if (n3 > 0) {
                    fileOutputStream.write(byArray, 0, n3);
                    n += n3;
                }
                if (progress.setProgress(n * 100 / n2)) continue;
                n3 = -2;
            }
            inputStream.close();
            fileOutputStream.close();
            s.fileSetExecPermission(string2);
            if (n3 == -2) {
                file.delete();
            }
        }
        catch (Exception exception) {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                    new File(string2).delete();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            progress.setVisible(false);
            JOptionPane.showMessageDialog(null, exception.toString() + "\nWhile downloading " + string + ".\nMaybe wrong proxy configuration?", "Xrefactory Error", 0);
        }
        progress.setVisible(false);
    }

    public static void setGlobalValues() {
        String string;
        int n;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        javaVersion = System.getProperty("java.version", "1.3.0");
        osName = System.getProperty("os.name").toLowerCase();
        archName = System.getProperty("os.arch").toLowerCase();
        if (osName.equals("mac os x")) {
            osName = "mac-os-x";
        }
        if (osName.indexOf("windows") != -1) {
            osName = "windows";
        }
        if (archName.indexOf("86") != -1) {
            archName = "x86";
        }
        if (osName.indexOf("windows") != -1) {
            osCode = 1;
            rootDir = "C:\\";
            string6 = "C:\\";
            string5 = "\\";
            string4 = ";";
            string3 = "_xrefrc";
            string2 = "xref.exe";
            homeDir = System.getProperty("user.home", "c:\\");
        } else {
            osCode = 0;
            rootDir = "/";
            string6 = "/tmp/";
            string5 = "/";
            string4 = ":";
            string3 = ".xrefrc";
            string2 = "xref";
            homeDir = System.getProperty("user.home", "~/");
        }
        String string7 = "xref-" + Protocol.VERSION_NUMBER + "-" + osName + "-" + archName + ".exe";
        xrefTaskUrl = xrefTaskDirUrl + string7;
        slash = System.getProperty("file.separator", string5);
        classPathSeparator = System.getProperty("path.separator", string4);
        tmpDirectoryPath = System.getProperty("java.io.tmpdir", string6);
        if (tmpDirectoryPath.substring(tmpDirectoryPath.length()) != slash) {
            tmpDirectoryPath = tmpDirectoryPath + slash;
        }
        if (homeDir.substring(homeDir.length()) != slash) {
            homeDir = homeDir + slash;
        }
        if ((javaHome = System.getProperty("java.home", rootDir)).substring(javaHome.length()) != slash) {
            javaHome = javaHome + slash;
        }
        String string8 = "/";
        String string9 = System.getProperty("java.class.path");
        if (string9 != null && (n = string9.toLowerCase().indexOf("jedit.jar")) != -1) {
            string = string9.substring(0, n);
            int n2 = string.lastIndexOf(classPathSeparator);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            string8 = string + "jars" + slash;
        }
        pluginInstallationPath = "";
        xrefTaskPath = "xref";
        String string10 = homeDir + ".jedit" + slash + "jars" + slash;
        string = homeDir + "jedit" + slash + "jars" + slash;
        if (new File(string10 + "Xrefactory.jar").exists()) {
            pluginInstallationPath = string10;
        } else if (new File(string + "Xrefactory.jar").exists()) {
            pluginInstallationPath = string;
        } else if (new File(string8 + "Xrefactory.jar").exists()) {
            pluginInstallationPath = string8;
        } else {
            System.err.println("[Xrefactory] can't find installation directory.");
            System.err.println("[Xrefactory] neither " + string10 + ", " + string);
            System.err.println("[Xrefactory] or " + string8 + " contains Xrefactory.jar");
        }
        xrefTaskPath = pluginInstallationPath + "Xrefactory" + slash + string2;
        jdkClassPath = javaHome + "lib" + slash + "rt.jar";
        configurationFile = jEdit.getProperty((String)configurationFileOption);
        if (configurationFile == null || configurationFile.equals("none")) {
            configurationFile = new File(homeDir + string3).getAbsolutePath();
            jEdit.setProperty((String)configurationFileOption, (String)configurationFile);
        }
        tagFilesDirectory = homeDir + "Xrefs" + slash;
        tagProcessingReportFile = tmpDirectoryPath + xrefLogFileSingleName;
        activeProject = null;
    }

    public static void checkIfXrefTaskExists() {
        if (xrefTaskYetChecked) {
            return;
        }
        xrefTaskYetChecked = true;
        File file = new File(xrefTaskPath);
        if (!file.exists() && !jEdit.getProperty((String)tryInstallXrefOption).equals(Protocol.VERSION_NUMBER)) {
            Object object = JOptionPane.showInputDialog(null, "You have  installed Xrefactory plugin. It requires shareware 'xref'\nnot  distributed with  the  plugin. However, xref can be  freely\ndownloaded   and   evaluated.   Can   I   download   xref   into\nfile: " + xrefTaskPath + "?", "Xrefactory installation", 3, null, new String[]{"Yes", "No", answerNoAndDoNotAskAnymore}, "Yes");
            if ("Yes".equals(object)) {
                s.downloadXrefTask(xrefTaskUrl, xrefTaskPath);
            } else if (answerNoAndDoNotAskAnymore.equals(object)) {
                jEdit.setProperty((String)tryInstallXrefOption, (String)Protocol.VERSION_NUMBER);
            }
        }
        if (!file.exists()) {
            xrefTaskPath = "xref";
        }
    }

    public static void checkVersionCorrespondance(String string, DispatchData dispatchData) {
        int n;
        if (!string.equals(Protocol.VERSION_NUMBER) && (n = JOptionPane.showConfirmDialog(s.getProbableParent(dispatchData.callerComponent), "You have installed Xrefactory version " + Protocol.VERSION_NUMBER + " while using\nxref  task version  " + string + ". Version mismatch  may cause\nproblems during  execution. Can I download correct  version of\nxref task?", "Xrefactory Problem", 0, 3)) == 0) {
            xbTask.killThis(false);
            s.downloadXrefTask(xrefTaskUrl, xrefTaskPath);
            dispatchData.panic = true;
        }
    }

    public static void checkBrowserTask() {
        if (xbTask == null) {
            s.cleanOldTmpFiles();
            s.checkIfXrefTaskExists();
            xbTask = new BrowserTask();
            DispatchData dispatchData = new DispatchData(xbTask, (Component)view);
            XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessSingleOpt("-olcheckversion=" + Protocol.VERSION_NUMBER, dispatchData);
            Dispatch.dispatch(xrefCharBuffer, dispatchData);
            if (dispatchData.panic) {
                xbTask = new BrowserTask();
            }
        }
    }

    public static void setGlobalValuesNoActiveProject(View view) {
        s.view = view;
        panic = false;
        s.checkBrowserTask();
    }

    public static void setGlobalValues(View view, boolean bl) {
        s.setGlobalValuesNoActiveProject(view);
        activeProject = s.computeActiveProject((Component)s.view, bl);
    }

    public static Position getPosition(View view) {
        Position position = new Position(view, view.getBuffer().getFile().getAbsolutePath(), view.getTextArea().getCaretPosition());
        return position;
    }

    public static void moveToPosition(View view, String string, int n) {
        Buffer buffer = jEdit.openFile((View)view, (String)string);
        VFSManager.waitForRequests();
        JEditTextArea jEditTextArea = view.getTextArea();
        jEditTextArea.setCaretPosition(n);
        VFSManager.waitForRequests();
    }

    public static void moveToPosition(Position position) {
        s.moveToPosition(position.view, position.file, position.offset);
    }

    public static void moveToPosition(View view, String string, int n, int n2) {
        block3: {
            Buffer buffer = jEdit.openFile((View)view, (String)string);
            VFSManager.waitForRequests();
            JEditTextArea jEditTextArea = view.getTextArea();
            int n3 = 0;
            int n4 = 0;
            try {
                n3 = jEditTextArea.getLineStartOffset(n - 1);
                n4 = jEditTextArea.getLineEndOffset(n - 1);
                if ((n3 += n2) > n4) {
                    n3 = n4;
                }
                jEditTextArea.setCaretPosition(n3);
                VFSManager.waitForRequests();
            }
            catch (Exception exception) {
                if (!debug) break block3;
                System.err.println("Problem while moving to " + string + " " + n + " " + n2);
            }
        }
    }

    public static void assertt(boolean bl) {
        if (!bl) {
            new Exception().printStackTrace();
            JOptionPane.showMessageDialog((Component)view, "An assertion Failed, an internal problem occurs.", "Xrefactory Error", 0);
        }
    }

    public static String sprintOption(String string) {
        String string2;
        if (string.indexOf(" ") == -1 && string.indexOf("\"") == -1 && !string.equals("") && string.charAt(0) != '\"') {
            string2 = string;
        } else {
            int n;
            string2 = "\"";
            int n2 = 0;
            while ((n = string.indexOf(34, n2)) != -1) {
                string2 = string2 + string.substring(n2, n) + "${dq}";
                n2 = n + 1;
            }
            string2 = string2 + string.substring(n2);
            string2 = string2 + "\"";
        }
        return string2;
    }

    public static boolean stringArrayEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(stringArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int skipNumber(XrefCharBuffer xrefCharBuffer, int n, int n2) {
        char c = xrefCharBuffer.buf[n];
        while (n < n2 && Character.isDigit(c)) {
            c = xrefCharBuffer.buf[++n];
        }
        return n;
    }

    public static int skipBlank(XrefCharBuffer xrefCharBuffer, int n, int n2) {
        while (n < n2 && Character.isWhitespace(xrefCharBuffer.buf[n])) {
            ++n;
        }
        return n;
    }

    public static void addGbcComponent(Container container, int n, int n2, int n3, int n4, int n5, int n6, int n7, Component component) {
        s.gbc.gridx = n;
        s.gbc.gridy = n2;
        s.gbc.gridwidth = n3;
        s.gbc.gridheight = n4;
        s.gbc.weightx = n5;
        s.gbc.weighty = n6;
        s.gbc.fill = n7;
        container.add(component, gbc);
    }

    public static void addButtonLine(JPanel jPanel, int n, JComponent[] jComponentArray, boolean bl) {
        int n2 = -1;
        s.addGbcComponent(jPanel, ++n2, n, 1, 1, 10, 10, 2, new JPanel());
        int n3 = 0;
        while (n3 < jComponentArray.length) {
            s.addGbcComponent(jPanel, ++n2, n, 1, 1, 1, 10, 2, jComponentArray[n3]);
            ++n3;
        }
        s.addGbcComponent(jPanel, ++n2, n, 1, 1, 10, 10, 2, new JPanel());
    }

    public static void addExtraButtonLine(Container container, int n, int n2, int n3, int n4, int n5, int n6, JComponent[] jComponentArray, boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        s.addButtonLine(jPanel, 0, jComponentArray, bl);
        s.addGbcComponent(container, n, n2, n3, n4, n5, n6, 2, jPanel);
    }

    public static String computeActiveProject(Component component, boolean bl) {
        DispatchData dispatchData = new DispatchData(xbTask, component);
        dispatchData.projectCreationAllowed = bl;
        XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessOnFileNoSaves(new String[]{"-olcxgetprojectname"}, dispatchData);
        Dispatch.dispatch(xrefCharBuffer, dispatchData);
        if (dispatchData.panic) {
            return null;
        }
        return dispatchData.project;
    }

    public static String computeSomeInformationInXref(Component component, String string) {
        DispatchData dispatchData = new DispatchData(xbTask, component);
        XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessOnFileNoSaves(new String[]{string}, dispatchData);
        Dispatch.dispatch(xrefCharBuffer, dispatchData);
        if (dispatchData.panic) {
            return null;
        }
        return dispatchData.info;
    }

    public static String computeSomeInformationInXref(Component component, String[] stringArray) {
        DispatchData dispatchData = new DispatchData(xbTask, component);
        XrefCharBuffer xrefCharBuffer = dispatchData.xTask.callProcessOnFileNoSaves(stringArray, dispatchData);
        Dispatch.dispatch(xrefCharBuffer, dispatchData);
        if (dispatchData.panic) {
            return null;
        }
        return dispatchData.info;
    }

    public static String getOrComputeActiveProject() {
        if (activeProject == null) {
            activeProject = s.computeActiveProject((Component)view, true);
        }
        return activeProject;
    }

    public static void displayProjectInformation() {
        String string = s.getOrComputeActiveProject();
        String string2 = string == null ? "Can't infer Xrefactory project!" : "Xrefactory project: " + string;
        SwingUtilities.invokeLater(new MessageDisplayer(string2, true));
    }

    public static char getBufferChar(Buffer buffer, int n) {
        return buffer.getText(n, 1).charAt(0);
    }

    static boolean projectExists(String string, Options[] optionsArray) {
        int n = 0;
        while (n < optionsArray.length) {
            if (optionsArray[n].projectName.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String commonPrefix(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        while (n3 < n && n3 < n2) {
            if (string.charAt(n3) != string2.charAt(n3)) break;
            ++n3;
        }
        return string.substring(0, n3);
    }

    public static String getIdentifierOnCaret() {
        int n;
        Buffer buffer = s.getBuffer();
        int n2 = buffer.getLength();
        int n3 = s.getCaretPosition();
        if (n3 == n2) {
            return "";
        }
        int n4 = n3;
        while (n4 > 0 && Character.isJavaIdentifierPart(s.getBufferChar(buffer, n4))) {
            --n4;
        }
        if (n4 > 0) {
            ++n4;
        }
        if (Character.isJavaIdentifierStart(s.getBufferChar(buffer, n = n4))) {
            while (n < n2 && Character.isJavaIdentifierPart(s.getBufferChar(buffer, n))) {
                ++n;
            }
        }
        return buffer.getText(n4, n - n4);
    }

    public static Point getAbsCoordinate(Point point, Component component) {
        double d = point.getX();
        double d2 = point.getY();
        while (component != null) {
            d += (double)component.getX();
            d2 += (double)component.getY();
            component = component.getParent();
        }
        return new Point((int)d, (int)d2);
    }

    public static Point recommendedLocation(Component component) {
        Point point = s.getTextArea().offsetToXY(s.getTextArea().getCaretPosition());
        if (point == null) {
            JOptionPane.showMessageDialog((Component)view, "Can't get caret position", "Xrefactory Error", 0);
            point = new Point(100, 100);
        } else {
            point = s.getAbsCoordinate(point, component);
        }
        FontMetrics fontMetrics = s.getTextArea().getPainter().getFontMetrics();
        return new Point((int)point.getX(), (int)point.getY() + fontMetrics.getHeight());
    }

    public static void moveOnScreen(Component component) {
        Point point = component.getLocation();
        Dimension dimension = component.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (point.getX() + dimension.getWidth() > dimension2.getWidth()) {
            point.setLocation(dimension2.getWidth() - dimension.getWidth(), point.getY());
        }
        if (point.getY() + dimension.getHeight() > dimension2.getHeight()) {
            point.setLocation(point.getX(), dimension2.getHeight() - dimension.getHeight());
        }
        component.setLocation((int)point.getX(), (int)point.getY());
    }

    public static String dotifyString(String string) {
        String string2 = string;
        string2 = string2.replace('/', '.');
        string2 = string2.replace('\\', '.');
        return string2;
    }

    public static int getNumberOfCharOccurences(String string, char c) {
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(c, n2)) != -1) {
            ++n2;
            ++n;
        }
        return n;
    }

    public static void arrayCopyDelElement(Object[] objectArray, Object[] objectArray2, int n) {
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - n - 1);
    }

    public static void arrayCopyAddElement(Object[] objectArray, Object[] objectArray2, int n) {
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        objectArray2[n] = null;
        System.arraycopy(objectArray, n, objectArray2, n + 1, objectArray.length - n);
    }

    public static String upperCaseFirstLetter(String string) {
        String string2 = string;
        int n = string.length();
        if (n > 0) {
            string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string2;
    }

    public static String lowerCaseFirstLetter(String string) {
        String string2 = string;
        int n = string.length();
        if (n > 0) {
            string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
        }
        return string2;
    }

    public static Component getProbableParent(Component component) {
        Component component2;
        Component component3 = component2 = component;
        while (component2 != null && !(component3 instanceof Window)) {
            component3 = component2;
            component2 = component2.getParent();
        }
        if (component3 == null) {
            component3 = view;
        }
        return component3;
    }

    public static View getParentView(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof View)) {
            component2 = component2.getParent();
        }
        if (component2 == null) {
            component2 = view;
        }
        return (View)component2;
    }

    public static JDialog getParentDialog(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof JDialog)) {
            component2 = component2.getParent();
        }
        return (JDialog)component2;
    }

    public static JFrame getParentFrame(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof JFrame)) {
            component2 = component2.getParent();
        }
        return (JFrame)component2;
    }

    public static ResolutionPanel getParentResolutionPanel(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof ResolutionPanel)) {
            component2 = component2.getParent();
        }
        return (ResolutionPanel)component2;
    }

    public static BrowserPanel getParentBrowserPanel(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof BrowserPanel)) {
            component2 = component2.getParent();
        }
        return (BrowserPanel)component2;
    }

    public static BrowserTopPanel getParentBrowserTopPanel(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof BrowserTopPanel)) {
            component2 = component2.getParent();
        }
        return (BrowserTopPanel)component2;
    }

    public static BrowserTopPanel.TreePanel getParentTreePanel(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof BrowserTopPanel.TreePanel)) {
            component2 = component2.getParent();
        }
        return (BrowserTopPanel.TreePanel)component2;
    }

    public static BrowserTopPanel.ReferencesPanel getParentReferencesPanel(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof BrowserTopPanel.ReferencesPanel)) {
            component2 = component2.getParent();
        }
        return (BrowserTopPanel.ReferencesPanel)component2;
    }

    public static String getViewParameter(int n) {
        return "view" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean synchronizedUpdateTagFile(Component component) {
        DispatchData dispatchData;
        String string = Opt.fullAutoUpdate() ? "-update" : "-fastupdate";
        XrefTaskForTagFile xrefTaskForTagFile = XrefTaskForTagFile.runXrefOnTagFile(string, "Updating Tags.", false, dispatchData = new DispatchData(xbTask, component));
        if (xrefTaskForTagFile == null) {
            return true;
        }
        Object object = xrefTaskForTagFile.lock;
        synchronized (object) {
            try {
                if (XrefTaskForTagFile.running) {
                    xrefTaskForTagFile.lock.wait();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return xrefTaskForTagFile.data.panic;
    }

    public static void dumpMemoryStatus() {
        Runtime runtime = Runtime.getRuntime();
        int n = (int)(runtime.freeMemory() / 1024L);
        int n2 = (int)(runtime.totalMemory() / 1024L);
        System.err.println(" memory " + n + "/" + n2);
    }

    public static void saveAllBuffers(View view) {
        jEdit.saveAllBuffers((View)view, (boolean)Opt.saveFilesAskForConfirmation());
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        VFSManager.waitForRequests();
    }

    public static void showTagFileReport(XrefCharBuffer xrefCharBuffer, Component component) {
        try {
            if (debug) {
                System.err.println("report==" + xrefCharBuffer.toString());
            }
            if (xrefCharBuffer.bufi != 0) {
                int n = 0;
                if (Opt.askBeforeBrowsingJavadoc()) {
                    n = JOptionPane.showConfirmDialog((Component)s.getParentView(component), "Done. View report ?", "Confirmation", 0, 3);
                }
                if (n == 0) {
                    SwingUtilities.invokeLater(new TagReportDisplayer(Dispatch.reportToHtml(xrefCharBuffer), component));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog((Component)view, "While reading report file: " + exception, "Xrefactory Error", 0);
        }
    }

    static {
        xbrowser = null;
        xHelpViewer = null;
        xExtractMethod = null;
        targetFile = null;
        targetLine = 0;
        panic = false;
        xrefTaskYetChecked = false;
        xbTask = null;
        currentTmpFileCounter = 0;
        tmpFileStep = 1;
        osCode = 0;
        LIGHT_GRAY = new Color(208, 208, 208);
        gbc = new GridBagConstraints();
    }

    static class tmpFileNameFilter
    implements FileFilter {
        long offset;

        public boolean accept(File file) {
            String string = file.getName();
            int n = string.length();
            if (n > 10 && string.substring(0, s.xrefTmpFilesPrefix.length()).equals(s.xrefTmpFilesPrefix) && string.substring(n - s.xrefTmpFilesSuffix.length()).equals(s.xrefTmpFilesSuffix)) {
                long l = System.currentTimeMillis() - this.offset;
                if (file.lastModified() < l) {
                    return true;
                }
            }
            return false;
        }

        tmpFileNameFilter(long l) {
            this.offset = l;
        }
    }

    public static class TagReportDisplayer
    implements Runnable {
        String report;
        Component caller;

        public void run() {
            JDialog jDialog = s.getParentDialog(this.caller);
            if (jDialog != null) {
                new TagReportDialog(this.report, jDialog);
            } else {
                JFrame jFrame = s.getParentFrame(this.caller);
                new TagReportDialog(this.report, jFrame);
            }
        }

        TagReportDisplayer(String string, Component component) {
            this.report = string;
            this.caller = component;
        }
    }

    public static class MessageDisplayer
    implements Runnable {
        String message;
        boolean temporary;

        public void run() {
            if (view != null && view.getStatus() != null) {
                if (this.temporary) {
                    view.getStatus().setMessageAndClear(this.message);
                } else {
                    view.getStatus().setMessage(this.message);
                }
            }
        }

        MessageDisplayer(String string, boolean bl) {
            this.message = string;
            this.temporary = bl;
        }
    }

    public static class Position {
        View view;
        String file;
        int offset;

        Position(View view, String string, int n) {
            this.view = view;
            this.file = string;
            this.offset = n;
        }
    }
}

