/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.Push;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefCtree;
import com.xrefactory.jedit.XrefRefListArea;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.XrefTask;
import com.xrefactory.jedit.s;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.gjt.sp.jedit.jEdit;

public class BrowserTopPanel
extends JPanel {
    public static final String[] refViews = new String[]{"Filter 0", "Filter 1", "Filter 2", "Filter 3"};
    public static final String[] treeViews = new String[]{"Equal Name", "Equal Profile", "Relevant"};
    DispatchData data;
    public JSplitPane splitPanel;
    public TreePanel treePanel;
    public ReferencesPanel referencesPanel;
    public static Font browserButtonFont = new Font(null, 0, 10);
    boolean needToUpdate = false;

    public void updateData() {
        s.Position pos = s.getPosition(s.getParentView(this));
        this.treePanel.treeFilter.setSelectedIndex(Opt.browserTreeFilter);
        this.needToUpdate = false;
        s.moveToPosition(pos);
    }

    public void needToUpdate() {
        if (s.browserIsDisplayed(this)) {
            this.updateData();
        } else {
            this.needToUpdate = true;
        }
    }

    public void paint(Graphics g) {
        if (this.needToUpdate) {
            this.needToUpdate();
        }
        super.paint(g);
    }

    BrowserTopPanel(DispatchData data, boolean allButtons, int split) {
        this.setLayout(new GridBagLayout());
        this.splitPanel = new JSplitPane(split, false);
        this.data = data;
        this.treePanel = new TreePanel(data, allButtons);
        this.splitPanel.setLeftComponent(this.treePanel);
        this.referencesPanel = new ReferencesPanel(data, allButtons);
        this.splitPanel.setRightComponent(this.referencesPanel);
        JComponent[] buttons = new JComponent[]{};
        int y = -1;
        s.addGbcComponent(this, 0, ++y, buttons.length + 2, 1, 100, 100, 1, this.splitPanel);
        int tdp = Opt.browserTreeDividerPosition();
        this.treePanel.setPreferredSize(new Dimension(tdp, 200));
        int rdp = 500 - tdp;
        if (rdp < 100) {
            rdp = 100;
        }
        this.referencesPanel.setPreferredSize(new Dimension(rdp, 200));
    }

    public class ReferencesPanel
    extends JPanel {
        DispatchData data;
        XrefRefListArea reflist;
        ComboBoxRefsFilter refFilter;

        public void updateSelection() {
            DispatchData ndata = new DispatchData(this.data, (Component)this);
            XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcxgetcurrentrefn", ndata);
            Dispatch.dispatch(receipt, ndata);
        }

        public void update() {
            DispatchData ndata = new DispatchData(this.data, (Component)this);
            XrefStringArray options = new XrefStringArray();
            options.add("-olcxfilter=" + Opt.browserRefListFilter);
            ndata.xTask.addFileProcessingOptions(options);
            XrefTask.addCommonOptions(options, ndata);
            XrefCharBuffer receipt = ndata.xTask.callProcess(options, ndata);
            Dispatch.dispatch(receipt, ndata);
        }

        ReferencesPanel(DispatchData data, boolean allButtons) {
            this.data = data;
            this.reflist = new XrefRefListArea(data);
            this.reflist.setFont(jEdit.getFontProperty((String)"xrefactory.browser-font", (Font)s.browserDefaultFont));
            this.reflist.setBackground(jEdit.getColorProperty((String)"xrefactory.browser-bgcolor", (Color)Color.white));
            this.reflist.setForeground(jEdit.getColorProperty((String)"xrefactory.browser-fgcolor", (Color)Color.black));
            this.refFilter = new ComboBoxRefsFilter();
            JScrollPane xrefs = new JScrollPane(this.reflist);
            this.setLayout(new GridBagLayout());
            int y = -1;
            s.addGbcComponent(this, 0, ++y, 1, 1, 100, 100, 1, xrefs);
        }

        class ButtonNext
        extends JButton
        implements ActionListener {
            ButtonNext() {
                super("Next");
                this.setToolTipText("Move to the next usage.");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                ReferencesPanel.this.reflist.next();
            }
        }

        class ButtonPrevious
        extends JButton
        implements ActionListener {
            ButtonPrevious() {
                super("Previous");
                this.setToolTipText("Move to the previous usage.");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                ReferencesPanel.this.reflist.previous();
            }
        }

        class ComboBoxRefsFilter
        extends JComboBox
        implements ActionListener {
            ComboBoxRefsFilter() {
                super(refViews);
                this.setToolTipText("Restrict displayed usages by applying filter.");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                Opt.browserRefListFilter = ReferencesPanel.this.refFilter.getSelectedIndex();
                ReferencesPanel.this.update();
            }
        }
    }

    public class TreePanel
    extends JPanel {
        DispatchData data;
        public XrefCtree xtree;
        public JComboBox treeView;
        public ComboBoxTreeFilter treeFilter;

        TreePanel(DispatchData data, boolean allButtons) {
            this.data = data;
            this.xtree = new XrefCtree(data, true);
            this.setLayout(new GridBagLayout());
            this.treeFilter = new ComboBoxTreeFilter();
            int y = -1;
            s.addGbcComponent(this, 0, ++y, 1, 1, 100, 100, 1, new JScrollPane(this.xtree));
        }

        class ComboBoxTreeFilter
        extends JComboBox
        implements ActionListener {
            ComboBoxTreeFilter() {
                super(treeViews);
                this.setToolTipText("Restrict displayed symbols by applying filter.");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                Opt.browserTreeFilter = TreePanel.this.treeFilter.getSelectedIndex();
                DispatchData ndata = new DispatchData(TreePanel.this.data, (Component)TreePanel.this);
                XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcxmenufilter=" + Opt.browserTreeFilter, ndata);
                Dispatch.dispatch(receipt, ndata);
                ((TreePanel)TreePanel.this).BrowserTopPanel.this.referencesPanel.refFilter.setSelectedIndex(Opt.browserRefListFilter);
            }
        }

        class ButtonDefault
        extends JButton
        implements ActionListener {
            ButtonDefault() {
                super("Default");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
            }
        }

        class ButtonNone
        extends JButton
        implements ActionListener {
            ButtonNone() {
                super("None");
                this.setToolTipText("Unselect all symbols on the top.");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                TreePanel.this.xtree.selectUnselectAll(false);
            }
        }

        class ButtonAll
        extends JButton
        implements ActionListener {
            ButtonAll() {
                super("All");
                this.setToolTipText("Select all symbols on the top.");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                TreePanel.this.xtree.selectUnselectAll(true);
            }
        }
    }

    class ButtonPush
    extends JButton
    implements ActionListener {
        ButtonPush() {
            super("Push");
            this.setToolTipText("Resolve symbol pointed by caret and push usages on the stack.");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            s.setGlobalValues(s.getParentView(BrowserTopPanel.this.data.callerComponent), true);
            s.displayProjectInformationLater();
            DispatchData ndata = new DispatchData(BrowserTopPanel.this.data, (Component)this);
            new Push(new String[]{"-olcxpush"}, ndata);
        }
    }

    class ButtonRePush
    extends JButton
    implements ActionListener {
        ButtonRePush() {
            super("Repush");
            this.setToolTipText("Undo last pop.");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            s.setGlobalValues(s.getParentView(BrowserTopPanel.this.data.callerComponent), true);
            s.displayProjectInformationLater();
            DispatchData ndata = new DispatchData(BrowserTopPanel.this.data, (Component)this);
            XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcxrepush", ndata);
            Dispatch.dispatch(receipt, ndata);
            if (!ndata.panic) {
                BrowserTopPanel.this.updateData();
            }
        }
    }

    class ButtonPop
    extends JButton
    implements ActionListener {
        ButtonPop() {
            super("Pop");
            this.setToolTipText("Remove one symbol from browser stack.");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            s.setGlobalValues(s.getParentView(BrowserTopPanel.this.data.callerComponent), true);
            DispatchData ndata = new DispatchData(BrowserTopPanel.this.data, (Component)this);
            XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcxpop", ndata);
            Dispatch.dispatch(receipt, ndata);
            if (!ndata.panic) {
                BrowserTopPanel.this.updateData();
            }
        }
    }
}

