/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.BrowserTask;
import com.xrefactory.jedit.BrowserTopPanel;
import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.DockableBrowser;
import com.xrefactory.jedit.DockableClassTree;
import com.xrefactory.jedit.DockableUrlBrowser;
import com.xrefactory.jedit.ExtractMethodDialog;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.Options;
import com.xrefactory.jedit.Progress;
import com.xrefactory.jedit.Refactorings;
import com.xrefactory.jedit.ResolutionPanel;
import com.xrefactory.jedit.TagReportDialog;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.XrefTaskForTagFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedButton;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class s {
    public static boolean debug = false;
    public static final String xrefRegistrationUrl = "http://www.xref-tech.com/license.html";
    public static final String xrefTaskDirUrl = "http://www.xref-tech.com/xrefactory/downloads/jedit/";
    public static final String dockableClassTreeWindowName = "xrefactory.class-tree-viewer";
    public static final String dockableUrlBrowserWindowName = "xrefactory.urlviewer";
    public static final String dockableBrowserWindowName = "xrefactory.browser";
    public static final String dockableRetrieverWindowName = "xrefactory.retriever";
    public static final String tryInstallXrefOption = "xrefactory.try-install-xref.prop";
    public static final String configurationFileOption = "xrefactory.configuration-file.prop";
    public static final String optCompletionFgColor = "xrefactory.completion-fgcolor";
    public static final String optCompletionSymbolFgColor = "xrefactory.completion-symbol-fgcolor";
    public static final String optCompletionBgColor = "xrefactory.completion-bgcolor";
    public static final String optCompletionBgColor2 = "xrefactory.completion-bgcolor2";
    public static final String optCompletionFont = "xrefactory.completion-font";
    public static final String optCompletionSymbolFont = "xrefactory.completion-symbol-font";
    public static final String optCompletionFqtLevel = "xrefactory.completion-fqtlevel";
    public static final String optCompletionCaseSensitive = "xrefactory.completion-cases";
    public static final String optCompletionDelPendingId = "xrefactory.completion-del-pending-id";
    public static final String optCompletionInsParenthesis = "xrefactory.completion-ins-parenthesis";
    public static final String optCompletionOldDialog = "xrefactory.completion-old-dialog";
    public static final String optBrowserFgColor = "xrefactory.browser-fgcolor";
    public static final String optBrowserBgColor = "xrefactory.browser-bgcolor";
    public static final String optBrowserSelectionColor = "xrefactory.browser-selcolor";
    public static final String optBrowserSymbolColor = "xrefactory.browser-symcolor";
    public static final String optBrowserNmSymbolColor = "xrefactory.browser-nmsymcolor";
    public static final String optBrowserFont = "xrefactory.browser-font";
    public static final String optBrowserToolBarPos = "xrefactory.browser-toolbar-position";
    public static final String optBrowserSrcWithRefs = "xrefactory.browser-src-code-in-references";
    public static final String optBrowserPickButton = "xrefactory.browser-pick-button";
    public static final String optBrowserRetrieveButton = "xrefactory.browser-retrieve-button";
    public static final String optRetrieverFgColor = "xrefactory.retriever-fgcolor";
    public static final String optRetrieverBgColor = "xrefactory.retriever-bgcolor";
    public static final String optRetrieverFont = "xrefactory.retriever-font";
    public static final String optRetrieverSearchButton = "xrefactory.retriever-search";
    public static final String optRetrieverBackButton = "xrefactory.retriever-back";
    public static final String optRetrieverForwardButton = "xrefactory.retriever-forward";
    public static final String optRefactoryCommentMovingLevel = "xrefactory.refactoring-comment-move";
    public static final String optRefactoryPreferImportOnDemand = "xrefactory.refactoring-imports-on-demand";
    public static final String projectAutoDetectionName = "None (Automatic Project Detection)";
    public static final String answerNoAndDoNotAskAnymore = "No and do not display this dialog anymore";
    public static final String xrefTmpFilesPrefix = "xrefactory";
    public static final String xrefTmpFilesSuffix = ".tmp";
    public static final String xrefLogFileSingleName = "xrefactory.log";
    public static String tagFilesDirectory;
    public static String tagProcessingReportFile;
    public static final int MAX_COMPLETION_HISTORY = 100;
    public static final int MAX_FILE_SIZE_FOR_READ = 20000000;
    public static final int MAX_FILE_SIZE_FOR_REPORT = 2000000;
    public static final int XREF_MAX_TREE_DEEP = 500;
    public static final int XREF_DOWNLOAD_BUFFER_SIZE = 1024;
    public static final String XREF_NON_MEMBER_SYMBOL_NAME = "NOT MEMBER SYMBOLS";
    public static View view;
    public static String activeProject;
    public static BrowserTopPanel xbrowser;
    public static HelpViewer xHelpViewer;
    public static ExtractMethodDialog.ExtractMethodPanel xExtractMethod;
    public static String completionIdAfterCaret;
    public static String completionIdBeforeCaret;
    public static String targetFile;
    public static int targetLine;
    public static boolean panic;
    public static boolean xrefTaskYetChecked;
    public static BrowserTask xbTask;
    public static String xrefTaskUrl;
    public static String rootDir;
    public static String slash;
    public static String classPathSeparator;
    public static String pluginInstallationPath;
    public static String tmpDirectoryPath;
    public static String osName;
    public static String archName;
    public static String jdkClassPath;
    public static String javaHome;
    public static String homeDir;
    public static String configurationFile;
    public static String xrefTaskPath;
    public static String javaVersion;
    public static int currentTmpFileCounter;
    public static int tmpFileStep;
    public static final int OS_OTHER = 0;
    public static final int OS_WINDOWS = 1;
    public static int osCode;
    public static Color light_gray;
    public static Color completionBgDefaultColor;
    public static Color completionBgDefaultColor2;
    public static Color completionSelectionColor;
    public static Font defaultFont;
    public static Font defaultComplSymFont;
    public static Font browserDefaultFont;
    public static Font optionsBrowseButtonFont;
    public static Font ctTopLevelFont;
    public static Font ctItalicBoldFont;
    public static Font ctItalicFont;
    public static Font ctBoldFont;
    public static Font ctNormalFont;
    public static Color ctBgColor;
    public static Color ctFgColor;
    public static Color ctSelectionColor;
    public static Color ctSymbolColor;
    public static Color ctNmSymbolColor;
    public static EmptyBorder emptyBorder;
    private static GridBagConstraints gbc;

    public static void setupCtreeFontsAndColors() {
        Font res = jEdit.getFontProperty((String)optBrowserFont, (Font)ctNormalFont);
        ctNormalFont = new Font(res.getName(), 0, res.getSize());
        ctBoldFont = new Font(res.getName(), 1, res.getSize());
        ctItalicFont = new Font(res.getName(), 2, res.getSize());
        ctItalicBoldFont = new Font(res.getName(), 3, res.getSize());
        ctTopLevelFont = new Font(res.getName(), 1, res.getSize() + 2);
        ctBgColor = jEdit.getColorProperty((String)optBrowserBgColor, (Color)ctBgColor);
        ctFgColor = jEdit.getColorProperty((String)optBrowserFgColor, (Color)ctFgColor);
        ctSelectionColor = jEdit.getColorProperty((String)optBrowserSelectionColor, (Color)ctSelectionColor);
        ctSymbolColor = jEdit.getColorProperty((String)optBrowserSymbolColor, (Color)ctSymbolColor);
        ctNmSymbolColor = jEdit.getColorProperty((String)optBrowserNmSymbolColor, (Color)ctNmSymbolColor);
    }

    public static void updateBrowserVisage() {
        View[] vs = jEdit.getViews();
        int i = 0;
        while (i < vs.length) {
            DockableClassTree ct;
            DockableBrowser db;
            BrowserTopPanel bb = s.getBrowser(vs[i]);
            if (bb != null) {
                bb.referencesPanel.reflist.setBackground(ctBgColor);
                bb.referencesPanel.reflist.setForeground(ctFgColor);
                bb.referencesPanel.reflist.setFont(ctNormalFont);
                bb.treePanel.xtree.setBackground(ctBgColor);
            }
            if ((db = s.getDockableBrowser(vs[i])) != null) {
                db.repositionToolBar();
            }
            if ((ct = s.getClassTreeViewer(vs[i])) != null) {
                ct.repositionToolBar();
                ct.tree.setBackground(ctBgColor);
            }
            ++i;
        }
    }

    public static File getNewTmpFileName() {
        File res;
        s.assertt(tmpFileStep != 0);
        do {
            res = new File(tmpDirectoryPath + xrefTmpFilesPrefix + currentTmpFileCounter + xrefTmpFilesSuffix);
            currentTmpFileCounter += tmpFileStep;
        } while (res.exists());
        return res;
    }

    public static void cleanOldTmpFiles() {
        int confirm;
        File tmp = new File(tmpDirectoryPath);
        File[] files = tmp.listFiles(new tmpFileNameFilter(172800000L));
        if (files.length > 0 && (confirm = JOptionPane.showConfirmDialog(null, "There are some old temporary files generated by Xrefactory, can I delete them?", "Xrefactory temporary files", 0)) == 0) {
            files = tmp.listFiles(new tmpFileNameFilter(86400000L));
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        }
    }

    public static boolean browserIsDisplayed() {
        return view.getDockableWindowManager().isDockableWindowVisible(dockableBrowserWindowName);
    }

    public static boolean browserIsDisplayed(Component cc) {
        View v = s.getParentView(cc);
        return v.getDockableWindowManager().isDockableWindowVisible(dockableBrowserWindowName);
    }

    public static DockableClassTree getClassTreeViewer(View view) {
        return (DockableClassTree)view.getDockableWindowManager().getDockable(dockableClassTreeWindowName);
    }

    public static DockableBrowser getDockableBrowser(View view) {
        DockableBrowser db = (DockableBrowser)view.getDockableWindowManager().getDockable(dockableBrowserWindowName);
        return db;
    }

    public static BrowserTopPanel getBrowser(View view) {
        DockableBrowser db = (DockableBrowser)view.getDockableWindowManager().getDockable(dockableBrowserWindowName);
        if (db != null) {
            return db.browser;
        }
        return xbrowser;
    }

    public static void beforePushBrowserFiltersUpdates() {
        Opt.browserTreeFilter = 2;
        if (!Opt.referencePushingsKeepBrowserFilter()) {
            Opt.browserRefListFilter = 0;
        }
    }

    public static void browserNeedsToUpdate(View view) {
        BrowserTopPanel browser = s.getBrowser(view);
        if (browser != null) {
            browser.needToUpdate();
        }
    }

    public static void showAndUpdateBrowser(View view) {
        view.getDockableWindowManager().showDockableWindow(dockableBrowserWindowName);
        s.browserNeedsToUpdate(view);
    }

    public static String getFileName() {
        return view.getBuffer().getPath();
    }

    public static int getCaretPosition() {
        return view.getTextArea().getCaretPosition();
    }

    public static JEditTextArea getTextArea() {
        return view.getTextArea();
    }

    public static Buffer getBuffer() {
        return view.getBuffer();
    }

    /*
     * WARNING - void declaration
     */
    public static String inferDefaultSourcePath() {
        char cc;
        int i;
        File ff = new File(s.getBuffer().getPath()).getParentFile();
        String path = ff.getAbsolutePath();
        String pp = s.getTextArea().getText();
        if (pp.length() > 7 && pp.substring(0, 7).equals("package")) {
            i = "package".length();
        } else {
            i = pp.indexOf("\npackage");
            if (i == -1) {
                return path;
            }
            i += "\npackage".length();
        }
        while (Character.isSpaceChar(pp.charAt(i))) {
            ++i;
        }
        int j = i;
        int count = 0;
        while (Character.isLetterOrDigit(cc = pp.charAt(j)) || Character.isSpaceChar(cc) || cc == '.') {
            void var3_6;
            if (Character.isLetterOrDigit((char)var3_6) || var3_6 == 46) {
                ++count;
            }
            ++j;
        }
        if (count >= path.length()) {
            return path;
        }
        int ressize = path.length() - count;
        while (ff.getAbsolutePath().length() > ressize) {
            ff = ff.getParentFile();
        }
        return ff.getAbsolutePath();
    }

    public static void fileSetExecPermission(String fname) {
        if (osName.toLowerCase().indexOf("linux") != -1 || osName.toLowerCase().indexOf("sunos") != -1 || osName.toLowerCase().indexOf("mac-os-x") != -1 || osName.toLowerCase().indexOf("unix") != -1) {
            String[] chmodcmd = new String[]{"chmod", "a+x", fname};
            try {
                Runtime.getRuntime().exec(chmodcmd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void downloadXrefTask(String url, String file) {
        if (debug) {
            System.err.println("Downloading " + url + " into " + file);
        }
        Progress progress = Progress.crNew(null, "Downloading xref task");
        FileOutputStream oo = null;
        InputStream ii = null;
        try {
            URLConnection con = new URL(url).openConnection();
            ii = con.getInputStream();
            File of = new File(file);
            if (!of.getParentFile().exists()) {
                of.getParentFile().mkdir();
            }
            oo = new FileOutputStream(of);
            byte[] buffer = new byte[1024];
            int progressi = 0;
            int progressn = con.getContentLength();
            int n = 1;
            while (n >= 0) {
                n = ii.read(buffer, 0, 1024);
                if (n > 0) {
                    oo.write(buffer, 0, n);
                    progressi += n;
                }
                if (progress.setProgress(progressi * 100 / progressn)) continue;
                n = -2;
            }
            ii.close();
            oo.close();
            s.fileSetExecPermission(file);
            if (n == -2) {
                of.delete();
            }
        }
        catch (Exception e) {
            try {
                if (oo != null) {
                    oo.close();
                    new File(file).delete();
                }
                if (ii != null) {
                    ii.close();
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            progress.setVisible(false);
            JOptionPane.showMessageDialog(null, e.toString() + "\nWhile downloading " + url + ".\nMaybe wrong proxy configuration?", "Xrefactory Error", 0);
        }
        progress.setVisible(false);
    }

    public static void setGlobalValues() {
        int i;
        String deftask;
        String defcfile;
        String defcpsep;
        String defslash;
        String deftmp;
        debug = jEdit.getBooleanProperty((String)"xrefactory.debug-mode", (boolean)debug);
        javaVersion = System.getProperty("java.version", "1.3.0");
        osName = System.getProperty("os.name").toLowerCase();
        archName = System.getProperty("os.arch").toLowerCase();
        if (osName.equals("mac os x")) {
            osName = "mac-os-x";
        }
        if (osName.indexOf("windows") != -1) {
            osName = "windows";
        }
        if (archName.indexOf("86") != -1) {
            archName = "x86";
        }
        if (debug) {
            System.err.println("[Xrefactory] os == " + osName);
            System.err.println("[Xrefactory] arch == " + archName);
        }
        if (osName.toLowerCase().indexOf("windows") != -1) {
            osCode = 1;
            rootDir = "C:\\";
            deftmp = "C:\\";
            defslash = "\\";
            defcpsep = ";";
            defcfile = "_xrefrc";
            deftask = "xref.exe";
            homeDir = System.getProperty("user.home", "c:\\");
        } else {
            osCode = 0;
            rootDir = "/";
            deftmp = "/tmp/";
            defslash = "/";
            defcpsep = ":";
            defcfile = ".xrefrc";
            deftask = "xref";
            homeDir = System.getProperty("user.home", "~/");
        }
        String downloadtask = "xref-2.0.0-" + osName + "-" + archName + ".exe";
        xrefTaskUrl = xrefTaskDirUrl + downloadtask;
        slash = System.getProperty("file.separator", defslash);
        classPathSeparator = System.getProperty("path.separator", defcpsep);
        tmpDirectoryPath = System.getProperty("java.io.tmpdir", deftmp);
        if (tmpDirectoryPath.substring(tmpDirectoryPath.length()) != slash) {
            tmpDirectoryPath = tmpDirectoryPath + slash;
        }
        if (homeDir.substring(homeDir.length()) != slash) {
            homeDir = homeDir + slash;
        }
        if ((javaHome = System.getProperty("java.home", rootDir)).substring(javaHome.length()) != slash) {
            javaHome = javaHome + slash;
        }
        String instdir = "/";
        String cp = System.getProperty("java.class.path");
        if (cp != null && (i = cp.toLowerCase().indexOf("jedit.jar")) != -1) {
            String ss = cp.substring(0, i);
            int j = ss.lastIndexOf(classPathSeparator);
            if (j != -1) {
                ss = ss.substring(j + 1);
            }
            instdir = ss + "jars" + slash;
        }
        pluginInstallationPath = "";
        xrefTaskPath = "xref";
        String path0 = jEdit.getSettingsDirectory();
        if (path0 != null) {
            path0 = path0 + slash + "jars" + slash;
        }
        String path1 = homeDir + ".jedit" + slash + "jars" + slash;
        String path2 = homeDir + "jedit" + slash + "jars" + slash;
        if (path0 != null && new File(path0 + "Xrefactory.jar").exists()) {
            pluginInstallationPath = path0;
        } else if (new File(path1 + "Xrefactory.jar").exists()) {
            pluginInstallationPath = path1;
        } else if (new File(path2 + "Xrefactory.jar").exists()) {
            pluginInstallationPath = path2;
        } else if (new File(instdir + "Xrefactory.jar").exists()) {
            pluginInstallationPath = instdir;
        } else {
            System.err.println("[Xrefactory] can't find installation directory.");
            System.err.println("[Xrefactory] neither " + path0 + ", " + path1 + ", ");
            System.err.println("[Xrefactory] " + path2 + " or " + instdir + " contains Xrefactory.jar");
        }
        xrefTaskPath = pluginInstallationPath + "Xrefactory" + slash + deftask;
        jdkClassPath = javaHome + "lib" + slash + "rt.jar";
        configurationFile = jEdit.getProperty((String)configurationFileOption);
        if (configurationFile == null || configurationFile.equals("none")) {
            configurationFile = new File(homeDir + defcfile).getAbsolutePath();
            jEdit.setProperty((String)configurationFileOption, (String)configurationFile);
        }
        tagFilesDirectory = homeDir + "Xrefs" + slash;
        tagProcessingReportFile = tmpDirectoryPath + xrefLogFileSingleName;
        activeProject = null;
    }

    public static void checkIfXrefTaskExists() {
        if (xrefTaskYetChecked) {
            return;
        }
        xrefTaskYetChecked = true;
        File taskfile = new File(xrefTaskPath);
        if (!taskfile.exists() && !jEdit.getProperty((String)tryInstallXrefOption).equals("2.0.0")) {
            Object confirm = JOptionPane.showInputDialog(null, "You have  installed Xrefactory plugin. It requires shareware 'xref'\nnot  distributed with  the  plugin. However, xref can be  freely\ndownloaded   and   evaluated.   Can   I   download   xref   into\nfile: " + xrefTaskPath + "?", "Xrefactory installation", 3, null, new String[]{"Yes", "No", answerNoAndDoNotAskAnymore}, "Yes");
            if ("Yes".equals(confirm)) {
                s.downloadXrefTask(xrefTaskUrl, xrefTaskPath);
            } else if (answerNoAndDoNotAskAnymore.equals(confirm)) {
                jEdit.setProperty((String)tryInstallXrefOption, (String)"2.0.0");
            }
        }
        if (!taskfile.exists()) {
            xrefTaskPath = "xref";
        }
    }

    public static void checkVersionCorrespondance(String taskVersion, DispatchData data) {
        int confirm;
        if (!taskVersion.equals("2.0.0") && (confirm = JOptionPane.showConfirmDialog(s.getProbableParent(data.callerComponent), "You have installed Xrefactory version 2.0.0 while using\nxref  task version  " + taskVersion + ". Version mismatch  may cause\nproblems during  execution. Can I download correct  version of\nxref task?", "Xrefactory Problem", 0, 3)) == 0) {
            xbTask.killThis(false);
            s.downloadXrefTask(xrefTaskUrl, xrefTaskPath);
            data.panic = true;
        }
    }

    public static void checkBrowserTask() {
        if (xbTask == null) {
            s.cleanOldTmpFiles();
            s.checkIfXrefTaskExists();
            xbTask = new BrowserTask();
            DispatchData ndata = new DispatchData(xbTask, (Component)view);
            XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcheckversion=2.0.0", ndata);
            Dispatch.dispatch(receipt, ndata);
            if (ndata.panic) {
                xbTask = new BrowserTask();
            }
        }
    }

    public static void setGlobalValuesNoActiveProject(View view) {
        s.view = view;
        panic = false;
        s.checkBrowserTask();
    }

    public static void setGlobalValues(View view, boolean projectCreationAllowed) {
        s.setGlobalValuesNoActiveProject(view);
        activeProject = s.computeActiveProject((Component)s.view, projectCreationAllowed);
    }

    public static Position getPosition(View v) {
        Position res = new Position(v, v.getBuffer().getPath(), v.getTextArea().getCaretPosition());
        return res;
    }

    public static void moveToPosition(View view, String file, int off) {
        Buffer buf = jEdit.openFile((View)view, (String)file);
        VFSManager.waitForRequests();
        JEditTextArea texta = view.getTextArea();
        texta.setCaretPosition(off);
        VFSManager.waitForRequests();
    }

    public static void moveToPosition(Position p) {
        s.moveToPosition(p.view, p.file, p.offset);
    }

    public static void moveToPosition(View view, String file, int line, int col) {
        block3: {
            Buffer buf = jEdit.openFile((View)view, (String)file);
            VFSManager.waitForRequests();
            JEditTextArea texta = view.getTextArea();
            int off = 0;
            int offmax = 0;
            try {
                off = texta.getLineStartOffset(line - 1);
                offmax = texta.getLineEndOffset(line - 1);
                if ((off += col) > offmax) {
                    off = offmax;
                }
                texta.setCaretPosition(off);
                VFSManager.waitForRequests();
            }
            catch (Exception eee) {
                if (!debug) break block3;
                System.err.println("Problem while moving to " + file + " " + line + " " + col);
            }
        }
    }

    public static void assertt(boolean b) {
        if (!b) {
            new Exception().printStackTrace();
            JOptionPane.showMessageDialog((Component)view, "An assertion Failed, an internal problem occurs.", "Xrefactory Error", 0);
        }
    }

    public static int countLines(String s2) {
        int i = -1;
        int n = 0;
        while ((i = s2.indexOf(10, i + 1)) != -1) {
            ++n;
        }
        if (n > 0 || s2.length() > 0) {
            ++n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static String sprintOption(String ss) {
        String res;
        if (ss.indexOf(" ") == -1 && ss.indexOf("\"") == -1 && !ss.equals("") && ss.charAt(0) != '\"') {
            res = ss;
        } else {
            int i;
            res = "\"";
            int ii = 0;
            while ((i = ss.indexOf(34, ii)) != -1) {
                void var2_3;
                res = res + ss.substring(ii, (int)var2_3) + "${dq}";
                ii = var2_3 + true;
            }
            res = res + ss.substring(ii);
            res = res + "\"";
        }
        return res;
    }

    public static boolean stringArrayEqual(String[] a1, String[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a1.length) {
            if (!a1[i].equals(a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int skipNumber(XrefCharBuffer ss, int i, int len) {
        char c = ss.buf[i];
        while (i < len && Character.isDigit(c)) {
            c = ss.buf[++i];
        }
        return i;
    }

    public static int skipBlank(XrefCharBuffer ss, int i, int len) {
        while (i < len && Character.isWhitespace(ss.buf[i])) {
            ++i;
        }
        return i;
    }

    public static void addGbcComponent(Container pane, int x, int y, int w, int h, int wx, int wy, int fill, Component cc) {
        s.gbc.gridx = x;
        s.gbc.gridy = y;
        s.gbc.gridwidth = w;
        s.gbc.gridheight = h;
        s.gbc.weightx = wx;
        s.gbc.weighty = wy;
        s.gbc.fill = fill;
        pane.add(cc, gbc);
    }

    public static void addButtonLine(JPanel panel, int y, JComponent[] components, boolean borders) {
        int x = -1;
        if (borders) {
            s.addGbcComponent(panel, ++x, y, 1, 1, 10, 10, 2, new JPanel());
        }
        int i = 0;
        while (i < components.length) {
            s.addGbcComponent(panel, ++x, y, 1, 1, 1, 10, 2, components[i]);
            ++i;
        }
        if (borders) {
            s.addGbcComponent(panel, ++x, y, 1, 1, 10, 10, 2, new JPanel());
        }
    }

    public static void addExtraButtonLine(Container thiss, int x, int y, int dx, int dy, int wx, int wy, JComponent[] buttons, boolean borders) {
        JPanel bp = new JPanel();
        bp.setLayout(new GridBagLayout());
        s.addButtonLine(bp, 0, buttons, borders);
        s.addGbcComponent(thiss, x, y, dx, dy, wx, wy, 2, bp);
    }

    public static void buttonsSetFont(JComponent[] buttons, Font font) {
        int i = 0;
        while (i < buttons.length) {
            buttons[i].setFont(font);
            ++i;
        }
    }

    public static void buttonsAddActionListener(JButton[] buttons, ActionListener listener) {
        int i = 0;
        while (i < buttons.length) {
            buttons[i].addActionListener(listener);
            ++i;
        }
    }

    public static String computeActiveProject(Component parent, boolean projectCreationAllowed) {
        DispatchData ndata = new DispatchData(xbTask, parent);
        ndata.projectCreationAllowed = projectCreationAllowed;
        s.xbTask.tmpOption.clear();
        s.xbTask.tmpOption.add("-olcxgetprojectname");
        xbTask.addCurrentFileOptions(s.xbTask.tmpOption);
        XrefCharBuffer receipt = xbTask.callProcess(s.xbTask.tmpOption, ndata);
        Dispatch.dispatch(receipt, ndata);
        if (ndata.panic) {
            return null;
        }
        return ndata.info;
    }

    static void performMovingRefactoring(String moption, String fieldOption) {
        if (targetLine > 0 && !targetFile.equals("")) {
            XrefStringArray xroption = new XrefStringArray();
            xroption.add(moption);
            xroption.add("-commentmovinglevel=" + jEdit.getIntegerProperty((String)optRefactoryCommentMovingLevel, (int)0));
            xroption.add("-movetargetfile=" + targetFile);
            xroption.add("-rfct-param1=" + targetLine);
            if (fieldOption != null) {
                xroption.add("-rfct-param2=" + fieldOption);
            }
            Refactorings.mainRefactorerInvocation(xroption, false);
        }
    }

    public static String computeSomeInformationInXref(Component parent, String option) {
        DispatchData ndata = new DispatchData(xbTask, parent);
        XrefCharBuffer receipt = ndata.xTask.callProcessOnFileNoSaves(new String[]{option}, ndata);
        Dispatch.dispatch(receipt, ndata);
        if (ndata.panic) {
            return null;
        }
        return ndata.info;
    }

    public static String computeSomeInformationInXref(Component parent, String[] options) {
        DispatchData ndata = new DispatchData(xbTask, parent);
        XrefCharBuffer receipt = ndata.xTask.callProcessOnFileNoSaves(options, ndata);
        Dispatch.dispatch(receipt, ndata);
        if (ndata.panic) {
            return null;
        }
        return ndata.info;
    }

    public static String getOrComputeActiveProject() {
        if (activeProject == null) {
            activeProject = s.computeActiveProject((Component)view, true);
        }
        return activeProject;
    }

    public static void displayProjectInformationLater() {
        String project = s.getOrComputeActiveProject();
        String message = project == null ? "Can't infer Xrefactory project!" : "Xrefactory project: " + project;
        SwingUtilities.invokeLater(new MessageDisplayer(message, true));
    }

    public static char getBufferChar(Buffer buffer, int offset) {
        return buffer.getText(offset, 1).charAt(0);
    }

    static boolean projectExists(String name, Options[] projects) {
        int i = 0;
        while (i < projects.length) {
            if (projects[i].projectName.equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String commonPrefix(String s1, String s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        int i = 0;
        while (i < l1 && i < l2) {
            if (s1.charAt(i) != s2.charAt(i)) break;
            ++i;
        }
        return s1.substring(0, i);
    }

    public static String getIdentifierOnCaret() {
        Buffer buffer = s.getBuffer();
        int len = buffer.getLength();
        int offset = s.getCaretPosition();
        if (offset == len) {
            return "";
        }
        int j = offset;
        while (j > 0 && Character.isJavaIdentifierPart(s.getBufferChar(buffer, j))) {
            --j;
        }
        if (j > 0) {
            ++j;
        }
        int i = j;
        while (i < len && Character.isJavaIdentifierPart(s.getBufferChar(buffer, i))) {
            ++i;
        }
        return buffer.getText(j, i - j);
    }

    public static String getIdentifierBeforeCaret() {
        Buffer buffer = s.getBuffer();
        int len = buffer.getLength();
        int offset = s.getCaretPosition();
        if (offset == len) {
            return "";
        }
        int j = offset - 1;
        while (j > 0 && Character.isJavaIdentifierPart(s.getBufferChar(buffer, j))) {
            --j;
        }
        if (j > 0) {
            ++j;
        }
        if (j >= offset) {
            return "";
        }
        return buffer.getText(j, offset - j);
    }

    public static String getIdentifierAfterCaret() {
        Buffer buffer = s.getBuffer();
        int len = buffer.getLength();
        int offset = s.getCaretPosition();
        if (offset == len) {
            return "";
        }
        int i = offset;
        while (i < len && Character.isJavaIdentifierPart(s.getBufferChar(buffer, i))) {
            ++i;
        }
        return buffer.getText(offset, i - offset);
    }

    public static Point getAbsCoordinate(Point pp, Component cc) {
        double x = pp.getX();
        double y = pp.getY();
        while (cc != null) {
            x += (double)cc.getX();
            y += (double)cc.getY();
            cc = cc.getParent();
        }
        return new Point((int)x, (int)y);
    }

    public static Point recommendedLocation(Component cc) {
        Point pp = s.getTextArea().offsetToXY(s.getTextArea().getCaretPosition());
        if (pp == null) {
            JOptionPane.showMessageDialog((Component)view, "Can't get caret position", "Xrefactory Error", 0);
            pp = new Point(100, 100);
        } else {
            pp = s.getAbsCoordinate(pp, cc);
        }
        FontMetrics fm = s.getTextArea().getPainter().getFontMetrics();
        return new Point((int)pp.getX(), (int)pp.getY() + fm.getHeight());
    }

    public static void moveOnScreen(Component cc) {
        Point ccloc = cc.getLocation();
        int x = (int)ccloc.getX();
        int y = (int)ccloc.getY();
        Dimension ccdimm = cc.getSize();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (x < 0) {
            x = 0;
        }
        if ((double)x + ccdimm.getWidth() > dim.getWidth()) {
            x = (int)(dim.getWidth() - ccdimm.getWidth());
        }
        if (y < 0) {
            y = 0;
        }
        if ((double)y + ccdimm.getHeight() > dim.getHeight()) {
            y = (int)(dim.getHeight() - ccdimm.getHeight());
        }
        cc.setLocation(x, y);
    }

    public static String dotifyString(String ss) {
        String res = ss;
        res = res.replace('/', '.');
        res = res.replace('\\', '.');
        return res;
    }

    public static int getNumberOfCharOccurences(String s2, char c) {
        int n = 0;
        int i = 0;
        while ((i = s2.indexOf(c, i)) != -1) {
            ++i;
            ++n;
        }
        return n;
    }

    public static void arrayCopyDelElement(Object[] src, Object[] dest, int i) {
        System.arraycopy(src, 0, dest, 0, i);
        System.arraycopy(src, i + 1, dest, i, src.length - i - 1);
    }

    public static void arrayCopyAddElement(Object[] src, Object[] dest, int i) {
        System.arraycopy(src, 0, dest, 0, i);
        dest[i] = null;
        System.arraycopy(src, i, dest, i + 1, src.length - i);
    }

    public static String upperCaseFirstLetter(String s2) {
        String res = s2;
        int slen = s2.length();
        if (slen > 0) {
            res = s2.substring(0, 1).toUpperCase() + s2.substring(1);
        }
        return res;
    }

    public static String lowerCaseFirstLetter(String s2) {
        String res = s2;
        int slen = s2.length();
        if (slen > 0) {
            res = s2.substring(0, 1).toLowerCase() + s2.substring(1);
        }
        return res;
    }

    public static Component getProbableParent(Component c) {
        Component cc;
        Component res = cc = c;
        while (cc != null && !(res instanceof Window)) {
            res = cc;
            cc = cc.getParent();
        }
        if (res == null) {
            res = view;
        }
        return res;
    }

    public static View getParentView(Component c) {
        Component cc = c;
        while (cc != null && !(cc instanceof View)) {
            cc = cc.getParent();
        }
        if (cc == null) {
            cc = view;
        }
        return (View)cc;
    }

    public static JDialog getParentDialog(Component c) {
        Component cc = c;
        while (cc != null && !(cc instanceof JDialog)) {
            cc = cc.getParent();
        }
        return (JDialog)cc;
    }

    public static JFrame getParentFrame(Component c) {
        Component cc = c;
        while (cc != null && !(cc instanceof JFrame)) {
            cc = cc.getParent();
        }
        return (JFrame)cc;
    }

    public static ResolutionPanel getParentResolutionPanel(Component c) {
        Component cc = c;
        while (cc != null && !(cc instanceof ResolutionPanel)) {
            cc = cc.getParent();
        }
        return (ResolutionPanel)cc;
    }

    public static DockableBrowser getParentBrowserPanel(Component c) {
        Component cc = c;
        while (cc != null && !(cc instanceof DockableBrowser)) {
            cc = cc.getParent();
        }
        return (DockableBrowser)cc;
    }

    public static BrowserTopPanel getParentBrowserTopPanel(Component c) {
        Component cc = c;
        while (cc != null && !(cc instanceof BrowserTopPanel)) {
            cc = cc.getParent();
        }
        return (BrowserTopPanel)cc;
    }

    public static BrowserTopPanel.TreePanel getParentTreePanel(Component c) {
        Component cc = c;
        while (cc != null && !(cc instanceof BrowserTopPanel.TreePanel)) {
            cc = cc.getParent();
        }
        return (BrowserTopPanel.TreePanel)cc;
    }

    public static BrowserTopPanel.ReferencesPanel getParentReferencesPanel(Component c) {
        Component cc = c;
        while (cc != null && !(cc instanceof BrowserTopPanel.ReferencesPanel)) {
            cc = cc.getParent();
        }
        return (BrowserTopPanel.ReferencesPanel)cc;
    }

    public static String getViewParameter(int viewId) {
        return "view" + viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean synchronizedUpdateTagFile(Component parent) {
        DispatchData ndata;
        String updateOption = Opt.fullAutoUpdate() ? "-update" : "-fastupdate";
        XrefTaskForTagFile tr = XrefTaskForTagFile.runXrefOnTagFile(updateOption, "Updating Tags.", false, ndata = new DispatchData(xbTask, parent));
        if (tr == null) {
            return true;
        }
        Object object = tr.lock;
        synchronized (object) {
            try {
                if (XrefTaskForTagFile.running) {
                    tr.lock.wait();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tr.data.panic;
    }

    public static void dumpMemoryStatus() {
        Runtime runtime = Runtime.getRuntime();
        int freeMemory = (int)(runtime.freeMemory() / 1024L);
        int totalMemory = (int)(runtime.totalMemory() / 1024L);
        System.err.println(" memory " + freeMemory + "/" + totalMemory);
    }

    public static void saveAllBuffers(View view) {
        jEdit.saveAllBuffers((View)view, (boolean)Opt.saveFilesAskForConfirmation());
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        VFSManager.waitForRequests();
    }

    public static void showTagFileReport(XrefCharBuffer report, Component caller) {
        try {
            if (debug) {
                System.err.println("report==" + report.toString());
            }
            if (report.bufi != 0) {
                String message = report.bufi > 2000000 ? "Done. The report is " + report.bufi + " chars long and may run jEdit out of memory. View the report anyway ?" : "Done. View report ?";
                int confirm = 0;
                confirm = JOptionPane.showConfirmDialog((Component)s.getParentView(caller), message, "Confirmation", 0, 3);
                if (confirm == 0) {
                    SwingUtilities.invokeLater(new TagReportDisplayer(Dispatch.reportToHtml(report), caller));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog((Component)view, "While reading report file: " + e, "Xrefactory Error", 0);
        }
    }

    public static String getExternBrowserName() {
        if (osName.toLowerCase().indexOf("linux") != -1) {
            return "mozilla";
        }
        if (osName.toLowerCase().indexOf("sunos") != -1) {
            return "netscape";
        }
        if (osName.toLowerCase().indexOf("mac-os-x") != -1) {
            return "konqueror";
        }
        if (osName.toLowerCase().indexOf("unix") != -1) {
            return "netscape";
        }
        return "CMD /C start";
    }

    public static void browseUrl(String url, boolean externBrowser, View view) {
        if (externBrowser) {
            String bb = s.getExternBrowserName();
            try {
                Runtime.getRuntime().exec(bb + " " + url);
            }
            catch (Exception e) {}
        } else {
            view.getStatus().setMessageAndClear("Url: " + url);
            view.getDockableWindowManager().showDockableWindow(dockableUrlBrowserWindowName);
            DockableUrlBrowser urlViewer = (DockableUrlBrowser)view.getDockableWindowManager().getDockableWindow(dockableUrlBrowserWindowName);
            urlViewer.setPreferredSize(new Dimension(400, 400));
            urlViewer.gotoURL(url, true);
        }
    }

    public static void insertCompletionDoNotMoveCaret(Buffer buffer, int offset, String completion) {
        int i;
        String ss = jEdit.getBooleanProperty((String)optCompletionDelPendingId) ? completion : completion + completionIdAfterCaret;
        int b = i = offset;
        int blen = buffer.getLength();
        while (i < blen && Character.isJavaIdentifierPart(buffer.getText(i, 1).charAt(0))) {
            ++i;
        }
        int cidlen = i - b;
        String cid = buffer.getText(b, i - b);
        String cprefix = s.commonPrefix(cid, ss);
        int cprefixlen = cprefix.length();
        buffer.remove(b + cprefixlen, cidlen - cprefixlen);
        buffer.insert(b + cprefixlen, ss.substring(cprefixlen));
    }

    public static void insertCompletion(Buffer buffer, int offset, String completion) {
        s.insertCompletionDoNotMoveCaret(buffer, offset, completion);
        s.getTextArea().setCaretPosition(offset + completion.length());
    }

    public static JToolBar loadToolBar(String name) {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        String buttons = jEdit.getProperty((String)name);
        if (buttons != null) {
            StringTokenizer st = new StringTokenizer(buttons);
            while (st.hasMoreTokens()) {
                String button = st.nextToken();
                if (button.equals("-")) {
                    toolBar.addSeparator();
                    continue;
                }
                EnhancedButton b = GUIUtilities.loadToolButton((String)button);
                if (b == null) continue;
                toolBar.add((Component)b);
            }
        }
        return toolBar;
    }

    static {
        xrefRegistrationUrl = xrefRegistrationUrl;
        xrefTaskDirUrl = xrefTaskDirUrl;
        dockableClassTreeWindowName = dockableClassTreeWindowName;
        dockableUrlBrowserWindowName = dockableUrlBrowserWindowName;
        dockableBrowserWindowName = dockableBrowserWindowName;
        dockableRetrieverWindowName = dockableRetrieverWindowName;
        tryInstallXrefOption = tryInstallXrefOption;
        configurationFileOption = configurationFileOption;
        optCompletionFgColor = optCompletionFgColor;
        optCompletionSymbolFgColor = optCompletionSymbolFgColor;
        optCompletionBgColor = optCompletionBgColor;
        optCompletionBgColor2 = optCompletionBgColor2;
        optCompletionFont = optCompletionFont;
        optCompletionSymbolFont = optCompletionSymbolFont;
        optCompletionFqtLevel = optCompletionFqtLevel;
        optCompletionCaseSensitive = optCompletionCaseSensitive;
        optCompletionDelPendingId = optCompletionDelPendingId;
        optCompletionInsParenthesis = optCompletionInsParenthesis;
        optCompletionOldDialog = optCompletionOldDialog;
        optBrowserFgColor = optBrowserFgColor;
        optBrowserBgColor = optBrowserBgColor;
        optBrowserSelectionColor = optBrowserSelectionColor;
        optBrowserSymbolColor = optBrowserSymbolColor;
        optBrowserNmSymbolColor = optBrowserNmSymbolColor;
        optBrowserFont = optBrowserFont;
        optBrowserToolBarPos = optBrowserToolBarPos;
        optBrowserSrcWithRefs = optBrowserSrcWithRefs;
        optBrowserPickButton = optBrowserPickButton;
        optBrowserRetrieveButton = optBrowserRetrieveButton;
        optRetrieverFgColor = optRetrieverFgColor;
        optRetrieverBgColor = optRetrieverBgColor;
        optRetrieverFont = optRetrieverFont;
        optRetrieverSearchButton = optRetrieverSearchButton;
        optRetrieverBackButton = optRetrieverBackButton;
        optRetrieverForwardButton = optRetrieverForwardButton;
        optRefactoryCommentMovingLevel = optRefactoryCommentMovingLevel;
        optRefactoryPreferImportOnDemand = optRefactoryPreferImportOnDemand;
        projectAutoDetectionName = projectAutoDetectionName;
        answerNoAndDoNotAskAnymore = answerNoAndDoNotAskAnymore;
        xrefTmpFilesPrefix = xrefTmpFilesPrefix;
        xrefTmpFilesSuffix = xrefTmpFilesSuffix;
        xrefLogFileSingleName = xrefLogFileSingleName;
        tagFilesDirectory = "/";
        tagProcessingReportFile = null;
        MAX_COMPLETION_HISTORY = 100;
        MAX_FILE_SIZE_FOR_READ = 20000000;
        MAX_FILE_SIZE_FOR_REPORT = 2000000;
        XREF_MAX_TREE_DEEP = 500;
        XREF_DOWNLOAD_BUFFER_SIZE = 1024;
        XREF_NON_MEMBER_SYMBOL_NAME = XREF_NON_MEMBER_SYMBOL_NAME;
        xbrowser = null;
        xHelpViewer = null;
        xExtractMethod = null;
        targetFile = "";
        targetLine = 0;
        panic = false;
        xrefTaskYetChecked = false;
        xbTask = null;
        currentTmpFileCounter = 0;
        tmpFileStep = 1;
        OS_OTHER = 0;
        OS_WINDOWS = 1;
        osCode = 0;
        light_gray = new Color(208, 208, 208);
        completionBgDefaultColor = new Color(255, 240, 200);
        completionBgDefaultColor2 = new Color(235, 220, 180);
        completionSelectionColor = new Color(200, 200, 255);
        defaultFont = new Font("Monospaced", 0, 12);
        defaultComplSymFont = new Font("Monospaced", 1, 12);
        browserDefaultFont = new Font(null, 0, 10);
        optionsBrowseButtonFont = new Font(null, 0, 10);
        ctTopLevelFont = new Font(null, 0, 12);
        ctItalicBoldFont = new Font(null, 3, 10);
        ctItalicFont = new Font(null, 2, 10);
        ctBoldFont = new Font(null, 1, 10);
        ctNormalFont = new Font(null, 0, 10);
        ctBgColor = Color.white;
        ctFgColor = Color.black;
        ctSelectionColor = Color.blue;
        ctSymbolColor = Color.red;
        ctNmSymbolColor = light_gray;
        emptyBorder = new EmptyBorder(0, 0, 0, 0);
        gbc = new GridBagConstraints();
    }

    static class tmpFileNameFilter
    implements FileFilter {
        long offset;

        public boolean accept(File f) {
            String name = f.getName();
            int len = name.length();
            if (len > 10 && name.substring(0, s.xrefTmpFilesPrefix.length()).equals(s.xrefTmpFilesPrefix) && name.substring(len - s.xrefTmpFilesSuffix.length()).equals(s.xrefTmpFilesSuffix)) {
                long testtime = System.currentTimeMillis() - this.offset;
                if (f.lastModified() < testtime) {
                    return true;
                }
            }
            return false;
        }

        tmpFileNameFilter(long offset) {
            this.offset = offset;
        }
    }

    public static class TagReportDisplayer
    implements Runnable {
        String report;
        Component caller;

        public void run() {
            JDialog pp = s.getParentDialog(this.caller);
            if (pp != null) {
                new TagReportDialog(this.report, pp);
            } else {
                JFrame ff = s.getParentFrame(this.caller);
                new TagReportDialog(this.report, ff);
            }
        }

        TagReportDisplayer(String report, Component caller) {
            this.report = report;
            this.caller = caller;
        }
    }

    public static class MessageDisplayer
    implements Runnable {
        String message;
        boolean temporary;

        public void run() {
            if (view != null && view.getStatus() != null) {
                if (this.temporary) {
                    view.getStatus().setMessageAndClear(this.message);
                } else {
                    view.getStatus().setMessage(this.message);
                }
            }
        }

        MessageDisplayer(String message, boolean temporary) {
            this.message = message;
            this.temporary = temporary;
        }
    }

    public static class FocusRequester
    implements Runnable {
        Component component;

        public void run() {
            this.component.requestFocus();
        }

        FocusRequester(Component component) {
            this.component = component;
        }
    }

    public static class Position {
        View view;
        String file;
        int offset;

        Position(View view, String file, int offset) {
            this.view = view;
            this.file = file;
            this.offset = offset;
        }
    }
}

